/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.transport.rsocket;

import io.netty.channel.Channel;
import io.netty.util.concurrent.EventExecutor;
import io.scalecube.services.transport.api.WorkerThreadChooser;
import io.scalecube.services.transport.rsocket.EventExecutorChooser;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.concurrent.Executor;
import java.util.stream.StreamSupport;

public class DefaultEventExecutorChooser
implements EventExecutorChooser {
    private final WorkerThreadChooser threadChooser;

    public DefaultEventExecutorChooser(WorkerThreadChooser threadChooser) {
        this.threadChooser = threadChooser;
    }

    @Override
    public EventExecutor getEventExecutor(Channel channel, Iterator<EventExecutor> iterator) {
        Executor[] executors;
        for (EventExecutor eventExecutor : executors = (EventExecutor[])StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).toArray(EventExecutor[]::new)) {
            if (!eventExecutor.inEventLoop()) continue;
            return eventExecutor;
        }
        String channelId = channel.id().asLongText();
        SocketAddress localAddress = channel.localAddress();
        SocketAddress remoteAddress = channel.remoteAddress();
        try {
            return (EventExecutor)this.threadChooser.getWorker(channelId, localAddress, remoteAddress, executors);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

