/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.registry;

import io.scalecube.services.ServiceEndpoint;
import io.scalecube.services.ServiceMethodDefinition;
import io.scalecube.services.ServiceReference;
import io.scalecube.services.ServiceRegistration;
import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.registry.api.RegistryEvent;
import io.scalecube.services.registry.api.ServiceRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jctools.maps.NonBlockingHashMap;
import reactor.core.publisher.DirectProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxProcessor;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;

public class ServiceRegistryImpl
implements ServiceRegistry {
    private final Map<String, ServiceEndpoint> serviceEndpoints = new NonBlockingHashMap<String, ServiceEndpoint>();
    private final Map<String, List<ServiceReference>> referencesByQualifier = new NonBlockingHashMap<String, List<ServiceReference>>();
    private final FluxProcessor<RegistryEvent, RegistryEvent> events = DirectProcessor.create();
    private final FluxSink<RegistryEvent> sink = this.events.serialize().sink();

    @Override
    public List<ServiceEndpoint> listServiceEndpoints() {
        return new ArrayList<ServiceEndpoint>(this.serviceEndpoints.values());
    }

    @Override
    public List<ServiceReference> listServiceReferences() {
        return this.serviceReferenceStream().collect(Collectors.toList());
    }

    @Override
    public List<ServiceReference> lookupService(ServiceMessage request) {
        List<ServiceReference> result = this.referencesByQualifier.get(request.qualifier());
        if (result == null || result.isEmpty()) {
            return Collections.emptyList();
        }
        String contentType = request.dataFormatOrDefault();
        return result.stream().filter(ref -> ref.contentTypes().contains(contentType)).collect(Collectors.toList());
    }

    @Override
    public boolean registerService(ServiceEndpoint serviceEndpoint) {
        boolean success;
        boolean bl = success = this.serviceEndpoints.putIfAbsent(serviceEndpoint.id(), serviceEndpoint) == null;
        if (success) {
            serviceEndpoint.serviceRegistrations().stream().flatMap(serviceRegistration -> serviceRegistration.methods().stream().map(sm -> new ServiceReference((ServiceMethodDefinition)sm, (ServiceRegistration)serviceRegistration, serviceEndpoint))).forEach(serviceReference -> {
                this.referencesByQualifier.computeIfAbsent(serviceReference.qualifier(), key -> new CopyOnWriteArrayList()).add(serviceReference);
                this.sink.next(RegistryEvent.createAdded(serviceReference));
            });
        }
        return success;
    }

    @Override
    public ServiceEndpoint unregisterService(String endpointId) {
        ServiceEndpoint serviceEndpoint = this.serviceEndpoints.remove(endpointId);
        if (serviceEndpoint != null) {
            this.referencesByQualifier.values().forEach(list -> list.stream().filter(sr -> sr.endpointId().equals(endpointId)).forEach(sr -> {
                list.remove(sr);
                this.sink.next(RegistryEvent.createRemoved(sr));
            }));
        }
        return serviceEndpoint;
    }

    Stream<ServiceReference> serviceReferenceStream() {
        return this.referencesByQualifier.values().stream().flatMap(Collection::stream);
    }

    @Override
    public Flux<RegistryEvent> listen() {
        return Flux.fromIterable(this.referencesByQualifier.values()).flatMap(Flux::fromIterable).map(RegistryEvent::createAdded).concatWith(this.events);
    }

    @Override
    public Mono<Void> close() {
        return Mono.create(sink -> {
            this.events.dispose();
            sink.success();
        });
    }
}

