/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.lang.reflect.Method;

public class Metrics {
    private final MetricRegistry registry;

    public Meter getMeter(String component, String methodName, String eventType) {
        return this.registry.meter(MetricRegistry.name(component, methodName, eventType));
    }

    public <T> Meter getMeter(Class<T> component, String methodName, String eventType) {
        return this.getMeter(component.getName(), methodName, eventType);
    }

    public Timer getTimer(String component, String methodName) {
        return this.registry.timer(MetricRegistry.name(component, methodName));
    }

    public <T> Timer getTimer(Class<T> component, String methodName) {
        return this.getTimer(component.getName(), methodName);
    }

    public Counter getCounter(String component, String methodName) {
        return this.registry.counter(MetricRegistry.name(component, methodName));
    }

    public <T> Counter getCounter(Class<T> component, String methodName) {
        return this.getCounter(component.getName(), methodName);
    }

    public <T> Gauge<T> register(String component, String methodName, final Gauge<T> gauge) {
        this.registry.register(MetricRegistry.name(component, methodName), new Gauge<T>(){

            @Override
            public T getValue() {
                return gauge.getValue();
            }
        });
        return gauge;
    }

    public <T, G> Gauge<G> register(Class<T> component, String methodName, Gauge<G> gauge) {
        return this.register(component.getName(), methodName, gauge);
    }

    public Histogram getHistogram(String component, String methodName, boolean biased) {
        return this.registry.histogram(MetricRegistry.name(component, methodName));
    }

    public <T> Histogram getHistogram(Class<T> component, String methodName, boolean biased) {
        return this.getHistogram(component.getName(), methodName, biased);
    }

    public Metrics(MetricRegistry registry) {
        this.registry = registry;
    }

    public static Timer timer(Metrics metrics, String component, String methodName) {
        if (metrics != null) {
            return metrics.getTimer(component, methodName);
        }
        return null;
    }

    public static Counter counter(Metrics metrics, String component, String methodName) {
        if (metrics != null) {
            return metrics.getCounter(component, methodName);
        }
        return null;
    }

    public static void mark(Meter meter) {
        if (meter != null) {
            meter.mark();
        }
    }

    public static void mark(Metrics metrics, Class component, String methodName, String eventType) {
        Metrics.mark(metrics, component.getName(), methodName, eventType);
    }

    public static void mark(Metrics metrics, String component, String methodName, String eventType) {
        if (metrics != null) {
            Metrics.mark(metrics.getMeter(component, methodName, eventType));
        }
    }

    public static void mark(Class<?> serviceInterface, Metrics metrics, Method method, String eventType) {
        if (metrics != null) {
            Meter meter = metrics.getMeter(serviceInterface, method.getName(), eventType);
            Metrics.mark(meter);
        }
    }

    public static Timer.Context time(Timer timer) {
        if (timer != null) {
            return timer.time();
        }
        return null;
    }

    public static void stop(Timer.Context ctx) {
        if (ctx != null) {
            ctx.stop();
        }
    }

    public static void inc(Counter counter) {
        if (counter != null) {
            counter.inc();
        }
    }

    public static void dec(Counter counter) {
        if (counter != null) {
            counter.dec();
        }
    }
}

