/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.api;

import io.scalecube.services.api.Qualifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ServiceMessage {
    static final String DEFAULT_DATA_FORMAT = "application/json";
    static final String HEADER_QUALIFIER = "q";
    static final String HEADER_STREAM_ID = "sid";
    static final String HEADER_DATA_TYPE = "_type";
    static final String HEADER_DATA_FORMAT = "_data_format";
    private Map<String, String> headers = Collections.emptyMap();
    private Object data;

    ServiceMessage() {
    }

    private ServiceMessage(Builder builder) {
        this.data = builder.data();
        this.headers = builder.headers();
    }

    public static Builder from(ServiceMessage message) {
        return ServiceMessage.builder().data(message.data()).headers(message.headers());
    }

    public static Builder builder() {
        return Builder.getInstance();
    }

    void setData(Object data) {
        this.data = data;
    }

    void setHeaders(Map<String, String> headers) {
        this.headers = Collections.unmodifiableMap(headers);
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public String header(String name) {
        return this.headers.get(name);
    }

    public String qualifier() {
        return this.header(HEADER_QUALIFIER);
    }

    public String streamId() {
        return this.header(HEADER_STREAM_ID);
    }

    public String dataFormat() {
        return this.header(HEADER_DATA_FORMAT);
    }

    public String dataFormatOrDefault() {
        String dataFormat = this.dataFormat();
        return dataFormat != null ? dataFormat : DEFAULT_DATA_FORMAT;
    }

    public <T> T data() {
        return (T)this.data;
    }

    public boolean hasData() {
        return this.data != null;
    }

    public boolean hasData(Class<?> dataClass) {
        if (dataClass == null) {
            return false;
        }
        if (dataClass.isPrimitive()) {
            return this.hasData();
        }
        return dataClass.isInstance(this.data);
    }

    public String toString() {
        return "ServiceMessage {headers: " + this.headers + ", data: " + this.data + '}';
    }

    public static class Builder {
        private Map<String, String> headers = new HashMap<String, String>();
        private Object data;

        private Builder() {
        }

        static Builder getInstance() {
            return new Builder();
        }

        private Object data() {
            return this.data;
        }

        public Builder data(Object data) {
            this.data = data;
            return this;
        }

        public Builder dataType(Class<?> data) {
            this.headers.put(ServiceMessage.HEADER_DATA_TYPE, data.getName());
            return this;
        }

        public Builder dataFormat(String dataFormat) {
            this.headers.put(ServiceMessage.HEADER_DATA_FORMAT, dataFormat);
            return this;
        }

        private Map<String, String> headers() {
            return this.headers;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers.putAll(headers);
            return this;
        }

        public Builder header(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        public Builder qualifier(String qualifier) {
            return this.header(ServiceMessage.HEADER_QUALIFIER, qualifier);
        }

        public Builder qualifier(String serviceName, String methodName) {
            return this.qualifier(Qualifier.asString(serviceName, methodName));
        }

        public Builder streamId(String streamId) {
            return this.header(ServiceMessage.HEADER_STREAM_ID, streamId);
        }

        public ServiceMessage build() {
            return new ServiceMessage(this);
        }
    }
}

