/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services;

import io.scalecube.services.CommunicationMode;
import io.scalecube.services.ServiceEndpoint;
import io.scalecube.services.ServiceMethodDefinition;
import io.scalecube.services.ServiceRegistration;
import io.scalecube.services.api.Qualifier;
import io.scalecube.transport.Address;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ServiceReference {
    private final String qualifier;
    private final String endpointId;
    private final String host;
    private final int port;
    private final String namespace;
    private final Set<String> contentTypes;
    private final Map<String, String> tags;
    private final String action;
    private final CommunicationMode mode;
    private final Address address;

    public ServiceReference(ServiceMethodDefinition serviceMethodDefinition, ServiceRegistration serviceRegistration, ServiceEndpoint serviceEndpoint) {
        this.endpointId = serviceEndpoint.id();
        this.host = serviceEndpoint.host();
        this.port = serviceEndpoint.port();
        this.namespace = serviceRegistration.namespace();
        this.contentTypes = Collections.unmodifiableSet(serviceEndpoint.contentTypes());
        this.tags = this.mergeTags(serviceMethodDefinition, serviceRegistration, serviceEndpoint);
        this.action = serviceMethodDefinition.getAction();
        this.mode = serviceMethodDefinition.getCommunicationMode();
        this.qualifier = Qualifier.asString(this.namespace, this.action);
        this.address = Address.create(this.host(), this.port());
    }

    public CommunicationMode mode() {
        return this.mode;
    }

    public String qualifier() {
        return this.qualifier;
    }

    public String endpointId() {
        return this.endpointId;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String namespace() {
        return this.namespace;
    }

    public Set<String> contentTypes() {
        return this.contentTypes;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public String action() {
        return this.action;
    }

    private Map<String, String> mergeTags(ServiceMethodDefinition serviceMethodDefinition, ServiceRegistration serviceRegistration, ServiceEndpoint serviceEndpoint) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.putAll(serviceEndpoint.tags());
        tags.putAll(serviceRegistration.tags());
        tags.putAll(serviceMethodDefinition.getTags());
        return tags;
    }

    public String toString() {
        return "ServiceReference{qualifier='" + this.qualifier + '\'' + ", endpointId='" + this.endpointId + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + ", namespace='" + this.namespace + '\'' + ", contentTypes='" + this.contentTypes + '\'' + ", tags=" + this.tags + ", action='" + this.action + '\'' + ", mode=" + (Object)((Object)this.mode) + '}';
    }

    public Address address() {
        return this.address;
    }
}

