/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services;

import io.scalecube.services.HeadAndTail;
import io.scalecube.services.Reflect;
import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.codec.ServiceMessageCodec;
import io.scalecube.services.exceptions.ExceptionProcessor;
import io.scalecube.services.exceptions.ServiceUnavailableException;
import io.scalecube.services.methods.MethodInfo;
import io.scalecube.services.methods.ServiceMethodRegistry;
import io.scalecube.services.metrics.Metrics;
import io.scalecube.services.registry.api.ServiceRegistry;
import io.scalecube.services.routing.RoundRobinServiceRouter;
import io.scalecube.services.routing.Router;
import io.scalecube.services.routing.Routers;
import io.scalecube.services.transport.api.ClientTransport;
import io.scalecube.transport.Address;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ServiceCall {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCall.class);
    private final ClientTransport transport;
    private final ServiceMethodRegistry methodRegistry;
    private final ServiceRegistry serviceRegistry;
    private final Router router;
    private final Metrics metrics;

    private ServiceCall(Call call) {
        this.transport = call.transport;
        this.methodRegistry = call.methodRegistry;
        this.serviceRegistry = call.serviceRegistry;
        this.router = call.router;
        this.metrics = call.metrics;
    }

    public Mono<Void> oneWay(ServiceMessage request) {
        return this.requestOne(request, Void.class).then();
    }

    public Mono<Void> oneWay(ServiceMessage request, Address address) {
        return this.requestOne(request, Void.class, address).then();
    }

    public Mono<ServiceMessage> requestOne(ServiceMessage request) {
        return this.requestOne(request, null);
    }

    public Mono<ServiceMessage> requestOne(ServiceMessage request, Class<?> responseType) {
        String qualifier = request.qualifier();
        if (this.methodRegistry.containsInvoker(qualifier)) {
            return this.methodRegistry.getInvoker(request.qualifier()).invokeOne(request, ServiceMessageCodec::decodeData).onErrorMap(ExceptionProcessor::mapException);
        }
        return this.addressLookup(request).flatMap(address -> this.requestOne(request, responseType, (Address)address));
    }

    public Mono<ServiceMessage> requestOne(ServiceMessage request, Class<?> responseType, Address address) {
        Objects.requireNonNull(address, "requestOne address paramter is required and must not be null");
        return this.transport.create(address).requestResponse(request).map(message -> ServiceMessageCodec.decodeData(message, responseType));
    }

    public Flux<ServiceMessage> requestMany(ServiceMessage request) {
        return this.requestMany(request, null);
    }

    public Flux<ServiceMessage> requestMany(ServiceMessage request, Class<?> responseType) {
        String qualifier = request.qualifier();
        if (this.methodRegistry.containsInvoker(qualifier)) {
            return this.methodRegistry.getInvoker(request.qualifier()).invokeMany(request, ServiceMessageCodec::decodeData).onErrorMap(ExceptionProcessor::mapException);
        }
        return this.addressLookup(request).flatMapMany(address -> this.requestMany(request, responseType, (Address)address));
    }

    public Flux<ServiceMessage> requestMany(ServiceMessage request, Class<?> responseType, Address address) {
        Objects.requireNonNull(address, "requestMany address paramter is required and must not be null");
        return this.transport.create(address).requestStream(request).map(message -> ServiceMessageCodec.decodeData(message, responseType));
    }

    public Flux<ServiceMessage> requestBidirectional(Publisher<ServiceMessage> publisher) {
        return this.requestBidirectional(publisher, null);
    }

    public Flux<ServiceMessage> requestBidirectional(Publisher<ServiceMessage> publisher, Class<?> responseType) {
        return Flux.from(HeadAndTail.createFrom(publisher)).flatMap(pair -> {
            ServiceMessage request = (ServiceMessage)pair.head();
            String qualifier = request.qualifier();
            Flux<ServiceMessage> messages = Flux.from(pair.tail()).startWith(request);
            if (this.methodRegistry.containsInvoker(qualifier)) {
                return this.methodRegistry.getInvoker(qualifier).invokeBidirectional(messages, ServiceMessageCodec::decodeData).onErrorMap(ExceptionProcessor::mapException);
            }
            return this.addressLookup(request).flatMapMany(address -> this.requestBidirectional((Publisher<ServiceMessage>)messages, responseType, (Address)address));
        });
    }

    public Flux<ServiceMessage> requestBidirectional(Publisher<ServiceMessage> publisher, Class<?> responseType, Address address) {
        Objects.requireNonNull(address, "requestBidirectional address paramter is required and must not be null");
        return this.transport.create(address).requestChannel(publisher).map(message -> ServiceMessageCodec.decodeData(message, responseType));
    }

    public <T> T api(Class<T> serviceInterface) {
        ServiceCall serviceCall = this;
        Map<Method, MethodInfo> genericReturnTypes = Reflect.methodsInfo(serviceInterface);
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{serviceInterface}, (proxy, method, params) -> {
            MethodInfo methodInfo = (MethodInfo)genericReturnTypes.get(method);
            Class<?> returnType = methodInfo.parameterizedReturnType();
            boolean isServiceMessage = methodInfo.isRequestTypeServiceMessage();
            Optional<Object> check = ServiceCall.toStringOrEqualsOrHashCode(method.getName(), serviceInterface, params);
            if (check.isPresent()) {
                return check.get();
            }
            Metrics.mark(serviceInterface, this.metrics, method, "request");
            switch (methodInfo.communicationMode()) {
                case FIRE_AND_FORGET: {
                    return serviceCall.oneWay(ServiceCall.toServiceMessage(methodInfo, params));
                }
                case REQUEST_RESPONSE: {
                    return serviceCall.requestOne(ServiceCall.toServiceMessage(methodInfo, params), returnType).transform(ServiceCall.asMono(isServiceMessage));
                }
                case REQUEST_STREAM: {
                    return serviceCall.requestMany(ServiceCall.toServiceMessage(methodInfo, params), returnType).transform(ServiceCall.asFlux(isServiceMessage));
                }
                case REQUEST_CHANNEL: {
                    return serviceCall.requestBidirectional(Flux.from((Publisher)params[0]).map(data -> ServiceCall.toServiceMessage(methodInfo, data)), returnType).transform(ServiceCall.asFlux(isServiceMessage));
                }
            }
            throw new IllegalArgumentException("Communication mode is not supported: " + method);
        });
    }

    private Mono<Address> addressLookup(ServiceMessage request) {
        return this.router.route(this.serviceRegistry, request).map(serviceReference -> Mono.just(serviceReference.address())).orElseGet(() -> Mono.error(ServiceCall.noReachableMemberException(request)));
    }

    private static ServiceMessage toServiceMessage(MethodInfo methodInfo, Object ... params) {
        return ServiceMessage.builder().qualifier(methodInfo.serviceName(), methodInfo.methodName()).data(methodInfo.parameterCount() != 0 ? params[0] : null).build();
    }

    private static Function<? super Flux<ServiceMessage>, ? extends Publisher<ServiceMessage>> asFlux(boolean isRequestTypeServiceMessage) {
        return flux -> isRequestTypeServiceMessage ? flux : flux.filter(ServiceMessage::hasData).map(ServiceMessage::data);
    }

    private static Function<? super Mono<ServiceMessage>, ? extends Publisher<ServiceMessage>> asMono(boolean isRequestTypeServiceMessage) {
        return mono -> isRequestTypeServiceMessage ? mono : mono.filter(ServiceMessage::hasData).map(ServiceMessage::data);
    }

    private static ServiceUnavailableException noReachableMemberException(ServiceMessage request) {
        LOGGER.error("Failed  to invoke service, No reachable member with such service definition [{}], args [{}]", (Object)request.qualifier(), (Object)request);
        return new ServiceUnavailableException("No reachable member with such service: " + request.qualifier());
    }

    private static Optional<Object> toStringOrEqualsOrHashCode(String method, Class<?> serviceInterface, Object ... args) {
        switch (method) {
            case "toString": {
                return Optional.of(serviceInterface.toString());
            }
            case "equals": {
                return Optional.of(serviceInterface.equals(args[0]));
            }
            case "hashCode": {
                return Optional.of(serviceInterface.hashCode());
            }
        }
        return Optional.empty();
    }

    public static class Call {
        private Router router = Routers.getRouter(RoundRobinServiceRouter.class);
        private Metrics metrics;
        private final ClientTransport transport;
        private final ServiceMethodRegistry methodRegistry;
        private final ServiceRegistry serviceRegistry;

        public Call(ClientTransport transport, ServiceMethodRegistry methodRegistry, ServiceRegistry serviceRegistry) {
            this.transport = transport;
            this.serviceRegistry = serviceRegistry;
            this.methodRegistry = methodRegistry;
        }

        public Call router(Class<? extends Router> routerType) {
            this.router = Routers.getRouter(routerType);
            return this;
        }

        public Call router(Router router) {
            this.router = router;
            return this;
        }

        public Call metrics(Metrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public ServiceCall create() {
            return new ServiceCall(this);
        }
    }
}

