/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services;

import io.scalecube.services.CommunicationMode;
import io.scalecube.services.Microservices;
import io.scalecube.services.ServiceCall;
import io.scalecube.services.annotations.AfterConstruct;
import io.scalecube.services.annotations.Inject;
import io.scalecube.services.annotations.RequestType;
import io.scalecube.services.annotations.Service;
import io.scalecube.services.annotations.ServiceMethod;
import io.scalecube.services.api.Qualifier;
import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.methods.MethodInfo;
import io.scalecube.services.routing.Router;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class Reflect {
    private static final Logger LOGGER = LoggerFactory.getLogger(Reflect.class);

    private Reflect() {
    }

    public static Microservices inject(Microservices microservices, Collection<Object> services) {
        services.forEach(service -> Arrays.stream(service.getClass().getDeclaredFields()).forEach(field -> Reflect.injectField(microservices, field, service)));
        services.forEach(service -> Reflect.processAfterConstruct(microservices, service));
        return microservices;
    }

    public static Class<?> parameterizedReturnType(Method method) {
        Type type = method.getGenericReturnType();
        if (type instanceof ParameterizedType) {
            try {
                return Class.forName(((ParameterizedType)type).getActualTypeArguments()[0].getTypeName());
            }
            catch (ClassNotFoundException e) {
                return Object.class;
            }
        }
        return Object.class;
    }

    public static Class<?> requestType(Method method) {
        if (method.getParameterTypes().length > 0) {
            if (method.isAnnotationPresent(RequestType.class)) {
                return method.getAnnotation(RequestType.class).value();
            }
            if (method.getGenericParameterTypes()[0] instanceof ParameterizedType) {
                try {
                    return Class.forName(Reflect.parameterizedRequestType(method).getTypeName());
                }
                catch (ClassNotFoundException e) {
                    return Object.class;
                }
            }
            if (ServiceMessage.class.equals(method.getParameterTypes()[0])) {
                return Object.class;
            }
            return method.getParameterTypes()[0];
        }
        return Void.TYPE;
    }

    public static Type parameterizedType(Object object) {
        Type type;
        if (object != null && (type = object.getClass().getGenericSuperclass()) instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return Object.class;
    }

    public static Map<Method, MethodInfo> methodsInfo(Class<?> serviceInterface) {
        return Collections.unmodifiableMap(Reflect.serviceMethods(serviceInterface).values().stream().collect(Collectors.toMap(Function.identity(), method1 -> new MethodInfo(Reflect.serviceName(serviceInterface), Reflect.methodName(method1), Reflect.parameterizedReturnType(method1), Reflect.communicationMode(method1), method1.getParameterCount(), Reflect.requestType(method1)))));
    }

    public static Type parameterizedRequestType(Method method) {
        Type type;
        if (method != null && method.getGenericParameterTypes().length > 0 && (type = method.getGenericParameterTypes()[0]) instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return Object.class;
    }

    public static String serviceName(Class<?> serviceInterface) {
        Service serviceAnnotation = serviceInterface.getAnnotation(Service.class);
        if (serviceAnnotation == null) {
            throw new IllegalArgumentException(String.format("Not a service interface: %s", serviceInterface));
        }
        return serviceAnnotation.value().length() > 0 ? serviceAnnotation.value() : serviceInterface.getName();
    }

    public static Map<String, Method> serviceMethods(Class<?> serviceInterface) {
        Map methods = Arrays.stream(serviceInterface.getMethods()).filter(method -> method.isAnnotationPresent(ServiceMethod.class)).collect(Collectors.toMap(Reflect::methodName, Function.identity()));
        return Collections.unmodifiableMap(methods);
    }

    public static Collection<Class<?>> serviceInterfaces(Object serviceObject) {
        Class<?>[] interfaces = serviceObject.getClass().getInterfaces();
        return Arrays.stream(interfaces).filter(interfaceClass -> interfaceClass.isAnnotationPresent(Service.class)).collect(Collectors.toList());
    }

    public static String methodName(Method method) {
        ServiceMethod methodAnnotation = method.getAnnotation(ServiceMethod.class);
        return methodAnnotation.value().length() > 0 ? methodAnnotation.value() : method.getName();
    }

    public static String qualifier(Class<?> serviceInterface, Method method) {
        return Qualifier.asString(Reflect.serviceName(serviceInterface), Reflect.methodName(method));
    }

    public static void validateMethodOrThrow(Method method) {
        Class<?> returnType = method.getReturnType();
        if (returnType.equals(Void.TYPE)) {
            return;
        }
        if (!Publisher.class.isAssignableFrom(returnType)) {
            throw new UnsupportedOperationException("Service method return type can be Publisher only");
        }
        if (method.getParameterCount() > 1) {
            throw new UnsupportedOperationException("Service method can accept 0 or 1 parameters only");
        }
    }

    public static CommunicationMode communicationMode(Method method) {
        Class<Object> returnType = method.getReturnType();
        if (Reflect.isRequestChannel(method)) {
            return CommunicationMode.REQUEST_CHANNEL;
        }
        if (returnType.isAssignableFrom(Flux.class)) {
            return CommunicationMode.REQUEST_STREAM;
        }
        if (returnType.isAssignableFrom(Mono.class)) {
            return CommunicationMode.REQUEST_RESPONSE;
        }
        if (returnType.isAssignableFrom(Void.TYPE)) {
            return CommunicationMode.FIRE_AND_FORGET;
        }
        throw new IllegalArgumentException("Service method is not supported (check return type or parameter type): " + method);
    }

    private static boolean isRequestChannel(Method method) {
        Class<?>[] reqTypes = method.getParameterTypes();
        return reqTypes.length > 0 && (Flux.class.isAssignableFrom(reqTypes[0]) || Publisher.class.isAssignableFrom(reqTypes[0]));
    }

    private static void injectField(Microservices microservices, Field field, Object service) {
        if (field.isAnnotationPresent(Inject.class) && field.getType().equals(Microservices.class)) {
            Reflect.setField(field, service, microservices);
        } else if (field.isAnnotationPresent(Inject.class) && Reflect.isService(field.getType())) {
            Inject injection = field.getAnnotation(Inject.class);
            Class<? extends Router> routerClass = injection.router();
            ServiceCall.Call call = microservices.call();
            if (!routerClass.isInterface()) {
                call.router(routerClass);
            }
            Object targetProxy = call.create().api(field.getType());
            Reflect.setField(field, service, targetProxy);
        }
    }

    private static void setField(Field field, Object object, Object value) {
        try {
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (Exception ex) {
            LOGGER.error("failed to set service proxy of type: {} reason:{}", (Object)object.getClass().getName(), (Object)ex.getMessage());
        }
    }

    private static void processAfterConstruct(Microservices microservices, Object targetInstance) {
        Method[] declaredMethods = targetInstance.getClass().getDeclaredMethods();
        Arrays.stream(declaredMethods).filter(method -> method.isAnnotationPresent(AfterConstruct.class)).forEach(afterConstructMethod -> {
            try {
                afterConstructMethod.setAccessible(true);
                Object[] parameters = Arrays.stream(afterConstructMethod.getParameters()).map(mapper -> {
                    if (mapper.getType().equals(Microservices.class)) {
                        return microservices;
                    }
                    if (Reflect.isService(mapper.getType())) {
                        return microservices.call().create().api(mapper.getType());
                    }
                    return null;
                }).toArray();
                afterConstructMethod.invoke(targetInstance, parameters);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    private static boolean isService(Class<?> type) {
        return type.isAnnotationPresent(Service.class);
    }
}

