/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services;

import com.codahale.metrics.MetricRegistry;
import io.scalecube.cluster.membership.IdGenerator;
import io.scalecube.services.Reflect;
import io.scalecube.services.ServiceCall;
import io.scalecube.services.ServiceEndpoint;
import io.scalecube.services.ServiceInfo;
import io.scalecube.services.discovery.ServiceScanner;
import io.scalecube.services.discovery.api.DiscoveryConfig;
import io.scalecube.services.discovery.api.ServiceDiscovery;
import io.scalecube.services.gateway.Gateway;
import io.scalecube.services.gateway.GatewayConfig;
import io.scalecube.services.methods.ServiceMethodRegistry;
import io.scalecube.services.methods.ServiceMethodRegistryImpl;
import io.scalecube.services.metrics.Metrics;
import io.scalecube.services.registry.ServiceRegistryImpl;
import io.scalecube.services.registry.api.ServiceRegistry;
import io.scalecube.services.transport.api.ClientTransport;
import io.scalecube.services.transport.api.ServerTransport;
import io.scalecube.services.transport.api.ServiceTransport;
import io.scalecube.services.transport.api.WorkerThreadChooser;
import io.scalecube.transport.Address;
import io.scalecube.transport.Addressing;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class Microservices {
    private final String id;
    private final Metrics metrics;
    private final Map<String, String> tags;
    private final List<ServiceInfo> serviceInfos = new ArrayList<ServiceInfo>();
    private final List<Function<ServiceCall.Call, Collection<Object>>> serviceProviders;
    private final ServiceRegistry serviceRegistry;
    private final ServiceMethodRegistry methodRegistry;
    private final ServiceTransportBootstrap transportBootstrap;
    private final GatewayBootstrap gatewayBootstrap;
    private final DiscoveryConfig.Builder discoveryConfig;
    private final ServiceDiscovery discovery;

    private Microservices(Builder builder) {
        this.id = IdGenerator.generateId();
        this.metrics = builder.metrics;
        this.tags = new HashMap<String, String>(builder.tags);
        this.serviceProviders = new ArrayList<Function<ServiceCall.Call, Collection<Object>>>(builder.serviceProviders);
        this.serviceRegistry = builder.serviceRegistry;
        this.methodRegistry = builder.methodRegistry;
        this.transportBootstrap = builder.transportBootstrap;
        this.gatewayBootstrap = builder.gatewayBootstrap;
        this.discovery = builder.discovery;
        this.discoveryConfig = builder.discoveryConfig;
    }

    public String id() {
        return this.id;
    }

    private Mono<Microservices> start() {
        return this.transportBootstrap.start(this.methodRegistry).flatMap(input -> {
            ClientTransport clientTransport = this.transportBootstrap.clientTransport();
            InetSocketAddress serviceAddress = this.transportBootstrap.listenAddress();
            ServiceCall.Call call = new ServiceCall.Call(clientTransport, this.methodRegistry, this.serviceRegistry).metrics(this.metrics);
            this.serviceProviders.stream().flatMap(serviceProvider -> ((Collection)serviceProvider.apply(call)).stream()).forEach(this::collectAndRegister);
            if (!this.serviceInfos.isEmpty()) {
                String serviceHost = serviceAddress.getHostString();
                int servicePort = serviceAddress.getPort();
                ServiceEndpoint endpoint = ServiceScanner.scan(this.serviceInfos, this.id, serviceHost, servicePort, this.tags);
                this.serviceRegistry.registerService(endpoint);
                this.discoveryConfig.endpoint(endpoint);
            }
            return Mono.just(call);
        }).flatMap(call -> this.discovery.start(this.discoveryConfig.serviceRegistry(this.serviceRegistry).build()).then(Mono.defer(this::doInjection)).then(Mono.defer(() -> this.startGateway((ServiceCall.Call)call))).then(Mono.just(this))).onErrorResume(ex -> Mono.when(Mono.error(ex), this.shutdown()).cast(Microservices.class));
    }

    private Mono<GatewayBootstrap> startGateway(ServiceCall.Call call) {
        Executor workerThreadPool = this.transportBootstrap.workerThreadPool();
        boolean preferNative = this.transportBootstrap.transport().isNativeSupported();
        return this.gatewayBootstrap.start(workerThreadPool, preferNative, call, this.metrics);
    }

    private Mono<Microservices> doInjection() {
        List<Object> serviceInstances = this.serviceInfos.stream().map(ServiceInfo::serviceInstance).collect(Collectors.toList());
        return Mono.just(Reflect.inject(this, serviceInstances));
    }

    private void collectAndRegister(Object serviceInstance) {
        ServiceInfo serviceInfo = serviceInstance instanceof ServiceInfo ? (ServiceInfo)serviceInstance : ServiceInfo.fromServiceInstance(serviceInstance).build();
        this.serviceInfos.add(serviceInfo);
        this.methodRegistry.registerService(serviceInfo.serviceInstance());
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ServiceRegistry serviceRegistry() {
        return this.serviceRegistry;
    }

    public InetSocketAddress serviceAddress() {
        return this.transportBootstrap.listenAddress();
    }

    public ServiceCall.Call call() {
        ClientTransport clientTransport = this.transportBootstrap.clientTransport();
        return new ServiceCall.Call(clientTransport, this.methodRegistry, this.serviceRegistry).metrics(this.metrics);
    }

    public InetSocketAddress gatewayAddress(String name, Class<? extends Gateway> gatewayClass) {
        return this.gatewayBootstrap.gatewayAddress(name, gatewayClass);
    }

    public Map<GatewayConfig, InetSocketAddress> gatewayAddresses() {
        return this.gatewayBootstrap.gatewayAddresses();
    }

    public ServiceDiscovery discovery() {
        return this.discovery;
    }

    public Mono<Void> shutdown() {
        return Mono.defer(() -> Mono.when(Optional.ofNullable(this.serviceRegistry).map(ServiceRegistry::close).orElse(Mono.empty()), Optional.ofNullable(this.discovery).map(ServiceDiscovery::shutdown).orElse(Mono.empty()), Optional.ofNullable(this.gatewayBootstrap).map(rec$ -> ((GatewayBootstrap)rec$).shutdown()).orElse(Mono.empty()), Optional.ofNullable(this.transportBootstrap).map(rec$ -> ((ServiceTransportBootstrap)rec$).shutdown()).orElse(Mono.empty())));
    }

    private static class ServiceTransportBootstrap {
        private int listenPort;
        private WorkerThreadChooser workerThreadChooser;
        private ServiceTransport transport;
        private ClientTransport clientTransport;
        private ServerTransport serverTransport;
        private Executor workerThreadPool;
        private InetSocketAddress listenAddress;
        private int numOfThreads = Runtime.getRuntime().availableProcessors();

        private ServiceTransportBootstrap() {
        }

        private ServiceTransportBootstrap listenPort(int listenPort) {
            this.listenPort = listenPort;
            return this;
        }

        private ServiceTransportBootstrap transport(ServiceTransport transport) {
            this.transport = transport;
            return this;
        }

        private ServiceTransport transport() {
            return this.transport;
        }

        private ClientTransport clientTransport() {
            return this.clientTransport;
        }

        public ServiceTransportBootstrap numOfThreads(int numOfThreads) {
            this.numOfThreads = numOfThreads;
            return this;
        }

        private Executor workerThreadPool() {
            return this.workerThreadPool;
        }

        private InetSocketAddress listenAddress() {
            return this.listenAddress;
        }

        private Mono<ServiceTransportBootstrap> start(ServiceMethodRegistry methodRegistry) {
            return Mono.defer(() -> {
                this.transport = Optional.ofNullable(this.transport).orElseGet(ServiceTransport::getTransport);
                this.workerThreadPool = this.transport.getWorkerThreadPool(this.numOfThreads, this.workerThreadChooser);
                this.clientTransport = this.transport.getClientTransport(this.workerThreadPool);
                this.serverTransport = this.transport.getServerTransport(this.workerThreadPool);
                String hostAddress = Addressing.getLocalIpAddress().getHostAddress();
                InetSocketAddress socketAddress = InetSocketAddress.createUnresolved(hostAddress, this.listenPort);
                this.listenAddress = this.serverTransport.bindAwait(socketAddress, methodRegistry);
                return Mono.just(this);
            });
        }

        private Mono<Void> shutdown() {
            return Mono.defer(() -> Mono.when(Optional.ofNullable(this.serverTransport).map(ServerTransport::stop).orElse(Mono.empty()), Optional.ofNullable(this.transport).map(transport -> transport.shutdown(this.workerThreadPool)).orElse(Mono.empty())));
        }
    }

    private static class GatewayBootstrap {
        private Set<GatewayConfig> gatewayConfigs = new HashSet<GatewayConfig>();
        private Map<GatewayConfig, Gateway> gatewayInstances = new HashMap<GatewayConfig, Gateway>();
        private Map<GatewayConfig, InetSocketAddress> gatewayAddresses = new HashMap<GatewayConfig, InetSocketAddress>();

        private GatewayBootstrap() {
        }

        private GatewayBootstrap addConfig(GatewayConfig config) {
            if (!this.gatewayConfigs.add(config)) {
                throw new IllegalArgumentException("GatewayConfig with name: '" + config.name() + "' and gatewayClass: '" + config.gatewayClass().getName() + "' was already defined");
            }
            return this;
        }

        private Mono<GatewayBootstrap> start(Executor workerThreadPool, boolean preferNative, ServiceCall.Call call, Metrics metrics) {
            return Flux.fromIterable(this.gatewayConfigs).flatMap(gatewayConfig -> {
                Class<? extends Gateway> gatewayClass = gatewayConfig.gatewayClass();
                Gateway gateway = Gateway.getGateway(gatewayClass);
                return gateway.start((GatewayConfig)gatewayConfig, workerThreadPool, preferNative, call, metrics).doOnSuccess(listenAddress -> {
                    this.gatewayInstances.put((GatewayConfig)gatewayConfig, gateway);
                    this.gatewayAddresses.put((GatewayConfig)gatewayConfig, (InetSocketAddress)listenAddress);
                });
            }).then(Mono.just(this));
        }

        private Mono<Void> shutdown() {
            return Mono.defer(() -> this.gatewayInstances != null && !this.gatewayInstances.isEmpty() ? Mono.when((Publisher[])this.gatewayInstances.values().stream().map(Gateway::stop).toArray(Mono[]::new)) : Mono.empty());
        }

        private InetSocketAddress gatewayAddress(String name, Class<? extends Gateway> gatewayClass) {
            Optional<GatewayConfig> result = this.gatewayAddresses.keySet().stream().filter(config -> config.name().equals(name)).filter(config -> config.gatewayClass() == gatewayClass).findFirst();
            if (!result.isPresent()) {
                throw new IllegalArgumentException("Didn't find gateway address under name: '" + name + "' and gateway class: '" + gatewayClass.getName() + "'");
            }
            return this.gatewayAddresses.get(result.get());
        }

        private Map<GatewayConfig, InetSocketAddress> gatewayAddresses() {
            return Collections.unmodifiableMap(this.gatewayAddresses);
        }
    }

    public static final class Builder {
        private Metrics metrics;
        private Map<String, String> tags = new HashMap<String, String>();
        private List<Function<ServiceCall.Call, Collection<Object>>> serviceProviders = new ArrayList<Function<ServiceCall.Call, Collection<Object>>>();
        private ServiceRegistry serviceRegistry = new ServiceRegistryImpl();
        private ServiceMethodRegistry methodRegistry = new ServiceMethodRegistryImpl();
        private ServiceDiscovery discovery = ServiceDiscovery.getDiscovery();
        private DiscoveryConfig.Builder discoveryConfig = DiscoveryConfig.builder();
        private ServiceTransportBootstrap transportBootstrap = new ServiceTransportBootstrap();
        private GatewayBootstrap gatewayBootstrap = new GatewayBootstrap();

        public Mono<Microservices> start() {
            return Mono.defer(() -> new Microservices(this).start());
        }

        public Microservices startAwait() {
            return this.start().block();
        }

        public Builder services(Object ... services) {
            this.serviceProviders.add(call -> Arrays.stream(services).collect(Collectors.toList()));
            return this;
        }

        public Builder services(Function<ServiceCall.Call, Collection<Object>> serviceProvider) {
            this.serviceProviders.add(serviceProvider);
            return this;
        }

        public Builder serviceRegistry(ServiceRegistry serviceRegistry) {
            this.serviceRegistry = serviceRegistry;
            return this;
        }

        public Builder methodRegistry(ServiceMethodRegistry methodRegistry) {
            this.methodRegistry = methodRegistry;
            return this;
        }

        public Builder discovery(ServiceDiscovery discovery) {
            this.discovery = discovery;
            return this;
        }

        public Builder transport(ServiceTransport transport) {
            this.transportBootstrap.transport(transport);
            return this;
        }

        public Builder discoveryPort(int port) {
            this.discoveryConfig.port(port);
            return this;
        }

        public Builder servicePort(int port) {
            this.transportBootstrap.listenPort(port);
            return this;
        }

        public Builder numOfThreads(int numOfThreads) {
            this.transportBootstrap.numOfThreads(numOfThreads);
            return this;
        }

        public Builder seeds(Address ... seeds) {
            this.discoveryConfig.seeds(seeds);
            return this;
        }

        public Builder discoveryConfig(DiscoveryConfig.Builder discoveryConfig) {
            this.discoveryConfig = discoveryConfig;
            return this;
        }

        public Builder metrics(MetricRegistry metrics) {
            this.metrics = new Metrics(metrics);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public Builder gateway(GatewayConfig config) {
            this.gatewayBootstrap.addConfig(config);
            return this;
        }
    }
}

