/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.benchmarks;

import com.codahale.metrics.MetricRegistry;
import java.io.File;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class BenchmarksSettings {
    private static final int N_THREADS = Runtime.getRuntime().availableProcessors();
    private static final Duration EXECUTION_TASK_DURATION = Duration.ofSeconds(60L);
    private static final Duration EXECUTION_TASK_INTERVAL = Duration.ZERO;
    private static final Duration MINIMAL_INTERVAL = Duration.ofMillis(100L);
    private static final Duration REPORTER_INTERVAL = Duration.ofSeconds(3L);
    private static final TimeUnit DURATION_UNIT = TimeUnit.MILLISECONDS;
    private static final TimeUnit RATE_UNIT = TimeUnit.SECONDS;
    private static final long NUM_OF_ITERATIONS = Long.MAX_VALUE;
    private static final Duration RAMP_UP_DURATION = Duration.ofSeconds(10L);
    private static final Duration RAMP_UP_INTERVAL = Duration.ofSeconds(1L);
    private static final boolean CONSOLE_REPORTER_ENABLED = true;
    private static final String ALIAS_PATTERN = "^[.a-zA-Z_0-9]+$";
    private static final Predicate<String> ALIAS_PREDICATE = Pattern.compile("^[.a-zA-Z_0-9]+$").asPredicate();
    private final int nThreads;
    private final Duration executionTaskDuration;
    private final Duration executionTaskInterval;
    private final Duration reporterInterval;
    private final File csvReporterDirectory;
    private final String taskName;
    private final TimeUnit durationUnit;
    private final TimeUnit rateUnit;
    private final MetricRegistry registry;
    private final long numOfIterations;
    private final Duration rampUpDuration;
    private final Duration rampUpInterval;
    private final boolean consoleReporterEnabled;
    private final int injectors;
    private final int messageRate;
    private final int injectorsPerRampUpInterval;
    private final int messagesPerExecutionInterval;
    private final Map<String, String> options;

    public static Builder from(String[] args) {
        Builder builder = new Builder();
        Builder.access$102(builder, args);
        return builder;
    }

    private BenchmarksSettings(Builder builder) {
        this.nThreads = builder.nThreads;
        this.executionTaskDuration = builder.executionTaskDuration;
        this.executionTaskInterval = builder.executionTaskInterval;
        this.reporterInterval = builder.reporterInterval;
        this.numOfIterations = builder.numOfIterations;
        this.consoleReporterEnabled = builder.consoleReporterEnabled;
        this.rampUpDuration = builder.rampUpDuration;
        this.rampUpInterval = builder.rampUpInterval;
        this.options = builder.options;
        this.durationUnit = builder.durationUnit;
        this.rateUnit = builder.rateUnit;
        this.injectorsPerRampUpInterval = builder.injectorsPerRampUpInterval;
        this.messagesPerExecutionInterval = builder.messagesPerExecutionInterval;
        this.injectors = builder.injectors;
        this.messageRate = builder.messageRate;
        this.registry = new MetricRegistry();
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        this.taskName = this.minifyClassName(stackTrace[stackTrace.length - 1].getClassName());
        String time = LocalDateTime.ofInstant(Instant.now(), ZoneOffset.UTC).format(DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss"));
        String alias = this.find("alias", this.taskName);
        if (!ALIAS_PREDICATE.test(alias)) {
            throw new IllegalArgumentException("alias '" + alias + "' must match pattern " + ALIAS_PATTERN);
        }
        this.csvReporterDirectory = Paths.get("reports", "benchmarks", alias, time).toFile();
        this.csvReporterDirectory.mkdirs();
    }

    public int nThreads() {
        return this.nThreads;
    }

    public Duration executionTaskDuration() {
        return this.executionTaskDuration;
    }

    public Duration executionTaskInterval() {
        return this.executionTaskInterval;
    }

    public Duration reporterInterval() {
        return this.reporterInterval;
    }

    public File csvReporterDirectory() {
        return this.csvReporterDirectory;
    }

    public String taskName() {
        return this.taskName;
    }

    public String find(String key, String defValue) {
        return this.options.getOrDefault(key, defValue);
    }

    public MetricRegistry registry() {
        return this.registry;
    }

    public TimeUnit durationUnit() {
        return this.durationUnit;
    }

    public TimeUnit rateUnit() {
        return this.rateUnit;
    }

    public long numOfIterations() {
        return this.numOfIterations;
    }

    public Duration rampUpDuration() {
        return this.rampUpDuration;
    }

    public Duration rampUpInterval() {
        return this.rampUpInterval;
    }

    public boolean consoleReporterEnabled() {
        return this.consoleReporterEnabled;
    }

    public int injectors() {
        return this.injectors;
    }

    public int messageRate() {
        return this.messageRate;
    }

    public int injectorsPerRampUpInterval() {
        return this.injectorsPerRampUpInterval;
    }

    public int messagesPerExecutionInterval() {
        return this.messagesPerExecutionInterval;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BenchmarksSettings{");
        sb.append("nThreads=").append(this.nThreads);
        sb.append(", executionTaskDuration=").append(this.executionTaskDuration);
        sb.append(", executionTaskInterval=").append(this.executionTaskInterval);
        sb.append(", numOfIterations=").append(this.numOfIterations);
        sb.append(", reporterInterval=").append(this.reporterInterval);
        sb.append(", csvReporterDirectory=").append(this.csvReporterDirectory);
        sb.append(", taskName='").append(this.taskName).append('\'');
        sb.append(", durationUnit=").append((Object)this.durationUnit);
        sb.append(", rateUnit=").append((Object)this.rateUnit);
        sb.append(", rampUpDuration=").append(this.rampUpDuration);
        sb.append(", rampUpInterval=").append(this.rampUpInterval);
        sb.append(", consoleReporterEnabled=").append(this.consoleReporterEnabled);
        sb.append(", registry=").append(this.registry);
        sb.append(", injectors=").append(this.injectors);
        sb.append(", messageRate=").append(this.messageRate);
        sb.append(", injectorsPerRampUpInterval=").append(this.injectorsPerRampUpInterval);
        sb.append(", messagesPerExecutionInterval=").append(this.messagesPerExecutionInterval);
        sb.append(", options=").append(this.options);
        sb.append('}');
        return sb.toString();
    }

    private String minifyClassName(String className) {
        return className.replaceAll("\\B\\w+(\\.[a-zA-Z])", "$1");
    }

    static /* synthetic */ int access$1700() {
        return N_THREADS;
    }

    static /* synthetic */ Duration access$1800() {
        return EXECUTION_TASK_DURATION;
    }

    static /* synthetic */ Duration access$1900() {
        return EXECUTION_TASK_INTERVAL;
    }

    static /* synthetic */ Duration access$2000() {
        return REPORTER_INTERVAL;
    }

    static /* synthetic */ TimeUnit access$2100() {
        return DURATION_UNIT;
    }

    static /* synthetic */ TimeUnit access$2200() {
        return RATE_UNIT;
    }

    static /* synthetic */ Duration access$2300() {
        return RAMP_UP_DURATION;
    }

    static /* synthetic */ Duration access$2400() {
        return RAMP_UP_INTERVAL;
    }

    public static class Builder {
        private final Map<String, String> options;
        private int nThreads = BenchmarksSettings.access$1700();
        private Duration executionTaskDuration = BenchmarksSettings.access$1800();
        private Duration executionTaskInterval = BenchmarksSettings.access$1900();
        private Duration reporterInterval = BenchmarksSettings.access$2000();
        private TimeUnit durationUnit = BenchmarksSettings.access$2100();
        private TimeUnit rateUnit = BenchmarksSettings.access$2200();
        private long numOfIterations = Long.MAX_VALUE;
        private Duration rampUpDuration = BenchmarksSettings.access$2300();
        private Duration rampUpInterval = BenchmarksSettings.access$2400();
        private boolean consoleReporterEnabled = true;
        private String[] args = new String[0];
        private int injectors;
        private int messageRate;
        private int injectorsPerRampUpInterval;
        private int messagesPerExecutionInterval;

        private Builder() {
            this.options = new HashMap<String, String>();
        }

        private Builder(Builder that) {
            this.options = that.options;
            this.nThreads = that.nThreads;
            this.executionTaskDuration = that.executionTaskDuration;
            this.executionTaskInterval = that.executionTaskInterval;
            this.reporterInterval = that.reporterInterval;
            this.durationUnit = that.durationUnit;
            this.rateUnit = that.rateUnit;
            this.numOfIterations = that.numOfIterations;
            this.rampUpDuration = that.rampUpDuration;
            this.rampUpInterval = that.rampUpInterval;
            this.consoleReporterEnabled = that.consoleReporterEnabled;
            this.args = that.args;
            this.injectorsPerRampUpInterval = that.injectorsPerRampUpInterval;
            this.messagesPerExecutionInterval = that.messagesPerExecutionInterval;
            this.injectors = that.injectors;
            this.messageRate = that.messageRate;
        }

        public Builder nThreads(int numThreads) {
            this.nThreads = numThreads;
            return this;
        }

        public Builder executionTaskDuration(Duration executionTaskDuration) {
            this.executionTaskDuration = executionTaskDuration;
            return this;
        }

        public Builder executionTaskInterval(Duration executionTaskInterval) {
            this.executionTaskInterval = executionTaskInterval;
            return this;
        }

        public Builder reporterInterval(Duration reporterInterval) {
            this.reporterInterval = reporterInterval;
            return this;
        }

        public Builder addOption(String key, String value) {
            this.options.put(key, value);
            return this;
        }

        public Builder durationUnit(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder rateUnit(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder numOfIterations(long numOfIterations) {
            this.numOfIterations = numOfIterations;
            return this;
        }

        public Builder rampUpDuration(Duration rampUpDuration) {
            this.rampUpDuration = rampUpDuration;
            return this;
        }

        public Builder rampUpInterval(Duration rampUpInterval) {
            this.rampUpInterval = rampUpInterval;
            return this;
        }

        public Builder consoleReporterEnabled(boolean consoleReporterEnabled) {
            this.consoleReporterEnabled = consoleReporterEnabled;
            return this;
        }

        public Builder injectors(int injectors) {
            this.injectors = injectors;
            return this;
        }

        public Builder messageRate(int messageRate) {
            this.messageRate = messageRate;
            return this;
        }

        public BenchmarksSettings build() {
            return new BenchmarksSettings(new Builder(this).parseArgs().calculateDynamicParams());
        }

        private Builder calculateDynamicParams() {
            if (this.injectors <= 0 && this.messageRate <= 0) {
                return this;
            }
            if (this.injectors <= 0) {
                throw new IllegalArgumentException("'injectors' must be greater than 0");
            }
            if (this.messageRate <= 0) {
                throw new IllegalArgumentException("'messageRate' must be greater than 0");
            }
            if (this.rampUpDuration.isZero()) {
                throw new IllegalArgumentException("'rampUpDuration' must be greater than 0");
            }
            if (this.rampUpDuration.compareTo(this.executionTaskDuration) > 0) {
                throw new IllegalArgumentException("'rampUpDuration' must be greater than 'executionTaskDuration'");
            }
            long rampUpDurationMillis = this.rampUpDuration.toMillis();
            if (rampUpDurationMillis / (long)this.injectors >= MINIMAL_INTERVAL.toMillis()) {
                this.injectorsPerRampUpInterval = 1;
                this.rampUpInterval = Duration.ofMillis(rampUpDurationMillis / (long)this.injectors);
            } else {
                long intervals = Math.floorDiv(rampUpDurationMillis, MINIMAL_INTERVAL.toMillis());
                this.injectorsPerRampUpInterval = (int)Math.floorDiv((long)this.injectors, intervals);
                this.rampUpInterval = MINIMAL_INTERVAL;
            }
            double injectorRate = (double)this.messageRate / (double)this.injectors;
            if (injectorRate <= 1.0) {
                this.messagesPerExecutionInterval = 1;
                this.executionTaskInterval = Duration.ofMillis((long)(1000.0 / injectorRate));
            } else {
                int maxInjectorsLoad = (int)Math.floorDiv((long)(this.injectors * 1000), MINIMAL_INTERVAL.toMillis());
                if (maxInjectorsLoad >= this.messageRate) {
                    this.messagesPerExecutionInterval = 1;
                    this.executionTaskInterval = Duration.ofMillis((long)Math.floorDiv(maxInjectorsLoad, this.messageRate) * MINIMAL_INTERVAL.toMillis());
                } else {
                    this.messagesPerExecutionInterval = Math.floorDiv(this.messageRate, maxInjectorsLoad);
                    this.executionTaskInterval = MINIMAL_INTERVAL;
                }
            }
            return this;
        }

        private Builder parseArgs() {
            if (this.args != null) {
                block24: for (String pair : this.args) {
                    String[] keyValue = pair.split("=", 2);
                    String key = keyValue[0];
                    String value = keyValue[1];
                    switch (key) {
                        case "nThreads": {
                            this.nThreads(Integer.parseInt(value));
                            continue block24;
                        }
                        case "executionTaskDurationInSec": {
                            this.executionTaskDuration(Duration.ofSeconds(Long.parseLong(value)));
                            continue block24;
                        }
                        case "executionTaskIntervalInMillis": {
                            this.executionTaskInterval(Duration.ofMillis(Long.parseLong(value)));
                            continue block24;
                        }
                        case "reporterIntervalInSec": {
                            this.reporterInterval(Duration.ofSeconds(Long.parseLong(value)));
                            continue block24;
                        }
                        case "numOfIterations": {
                            this.numOfIterations(Long.parseLong(value));
                            continue block24;
                        }
                        case "rampUpDurationInSec": {
                            this.rampUpDuration(Duration.ofSeconds(Long.parseLong(value)));
                            continue block24;
                        }
                        case "rampUpIntervalInMillis": {
                            this.rampUpInterval(Duration.ofMillis(Long.parseLong(value)));
                            continue block24;
                        }
                        case "consoleReporterEnabled": {
                            this.consoleReporterEnabled(Boolean.parseBoolean(value));
                            continue block24;
                        }
                        case "injectors": {
                            this.injectors(Integer.parseInt(value));
                            continue block24;
                        }
                        case "messageRate": {
                            this.messageRate(Integer.parseInt(value));
                            continue block24;
                        }
                        default: {
                            this.addOption(key, value);
                        }
                    }
                }
            }
            return this;
        }

        static /* synthetic */ String[] access$102(Builder x0, String[] x1) {
            x0.args = x1;
            return x1;
        }
    }
}

