/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube;

public final class Throwables {
    private Throwables() {
    }

    public static UncheckedException propagate(Throwable throwable) {
        Throwables.propagateIfPossible(throwable);
        throw new UncheckedException(throwable);
    }

    public static void propagateIfPossible(Throwable throwable) {
        Throwables.propagateIfInstanceOf(throwable, Error.class);
        Throwables.propagateIfInstanceOf(throwable, RuntimeException.class);
    }

    public static <X extends Throwable> void propagateIfInstanceOf(Throwable throwable, Class<X> declaredType) throws X {
        if (throwable != null && declaredType.isInstance(throwable)) {
            throw (Throwable)declaredType.cast(throwable);
        }
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable cause;
        Throwable result = throwable;
        while ((cause = result.getCause()) != null) {
            result = cause;
        }
        return result;
    }

    private static class UncheckedException
    extends RuntimeException {
        private UncheckedException(Throwable cause) {
            super(cause);
        }
    }
}

