/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty;

import io.rsocket.DuplexConnection;
import io.rsocket.Frame;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.NettyInbound;
import reactor.ipc.netty.NettyOutbound;

public final class TcpDuplexConnection
implements DuplexConnection {
    private final NettyContext context;
    private final NettyInbound in;
    private final NettyOutbound out;

    public TcpDuplexConnection(NettyInbound in, NettyOutbound out, NettyContext context) {
        this.in = in;
        this.out = out;
        this.context = context;
    }

    @Override
    public void dispose() {
        this.context.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.context.isDisposed();
    }

    @Override
    public Mono<Void> onClose() {
        return this.context.onClose();
    }

    @Override
    public Flux<Frame> receive() {
        return this.in.receive().map(buf -> Frame.from(buf.retain()));
    }

    @Override
    public Mono<Void> send(Publisher<Frame> frames) {
        return Flux.from(frames).concatMap(this::sendOne).then();
    }

    @Override
    public Mono<Void> sendOne(Frame frame) {
        return this.out.sendObject(frame.content()).then();
    }
}

