/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.fragmentation;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.framing.FragmentableFrame;
import io.rsocket.framing.Frame;
import io.rsocket.framing.PayloadFrame;
import io.rsocket.util.DisposableUtils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.SynchronousSink;
import reactor.util.annotation.Nullable;

final class FrameFragmenter {
    private final ByteBufAllocator byteBufAllocator;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final int maxFragmentSize;

    FrameFragmenter(ByteBufAllocator byteBufAllocator, int maxFragmentSize) {
        this.byteBufAllocator = Objects.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        this.maxFragmentSize = maxFragmentSize;
    }

    public Flux<Frame> fragment(Frame frame) {
        Objects.requireNonNull(frame, "frame must not be null");
        if (!this.shouldFragment(frame)) {
            this.logger.debug("Not fragmenting {}", (Object)frame);
            return Flux.just(frame);
        }
        this.logger.debug("Fragmenting {}", (Object)frame);
        return Flux.generate(() -> new FragmentationState((FragmentableFrame)frame), this::generate, FragmentationState::dispose);
    }

    private FragmentationState generate(FragmentationState state, SynchronousSink<Frame> sink) {
        ByteBuf data;
        ByteBuf metadata;
        int fragmentLength = this.maxFragmentSize;
        if (state.hasReadableMetadata()) {
            metadata = state.readMetadataFragment(fragmentLength);
            fragmentLength -= metadata.readableBytes();
        } else {
            metadata = null;
        }
        if (state.hasReadableMetadata()) {
            Frame fragment = state.createFrame(this.byteBufAllocator, false, metadata, null);
            this.logger.debug("Fragment {}", (Object)fragment);
            sink.next(fragment);
            return state;
        }
        ByteBuf byteBuf = data = state.hasReadableData() ? state.readDataFragment(fragmentLength) : null;
        if (state.hasReadableData()) {
            Frame fragment = state.createFrame(this.byteBufAllocator, false, metadata, data);
            this.logger.debug("Fragment {}", (Object)fragment);
            sink.next(fragment);
            return state;
        }
        Frame fragment = state.createFrame(this.byteBufAllocator, true, metadata, data);
        this.logger.debug("Final Fragment {}", (Object)fragment);
        sink.next(fragment);
        sink.complete();
        return state;
    }

    private int getFragmentableLength(FragmentableFrame fragmentableFrame) {
        return fragmentableFrame.getMetadataLength().orElse(0) + fragmentableFrame.getDataLength();
    }

    private boolean shouldFragment(Frame frame) {
        if (this.maxFragmentSize == 0 || !(frame instanceof FragmentableFrame)) {
            return false;
        }
        FragmentableFrame fragmentableFrame = (FragmentableFrame)frame;
        return !fragmentableFrame.isFollowsFlagSet() && this.getFragmentableLength(fragmentableFrame) > this.maxFragmentSize;
    }

    static final class FragmentationState
    implements Disposable {
        private final FragmentableFrame frame;
        private int dataIndex = 0;
        private boolean initialFragmentCreated = false;
        private int metadataIndex = 0;

        FragmentationState(FragmentableFrame frame) {
            this.frame = frame;
        }

        @Override
        public void dispose() {
            DisposableUtils.disposeQuietly(this.frame);
        }

        Frame createFrame(ByteBufAllocator byteBufAllocator, boolean complete, @Nullable ByteBuf metadata, @Nullable ByteBuf data) {
            if (this.initialFragmentCreated) {
                return PayloadFrame.createPayloadFrame(byteBufAllocator, !complete, data == null, metadata, data);
            }
            this.initialFragmentCreated = true;
            return this.frame.createFragment(byteBufAllocator, metadata, data);
        }

        boolean hasReadableData() {
            return this.frame.getDataLength() - this.dataIndex > 0;
        }

        boolean hasReadableMetadata() {
            Integer metadataLength = this.frame.getUnsafeMetadataLength();
            return metadataLength != null && metadataLength - this.metadataIndex > 0;
        }

        ByteBuf readDataFragment(int length) {
            int safeLength = Math.min(length, this.frame.getDataLength() - this.dataIndex);
            ByteBuf fragment = this.frame.getUnsafeData().slice(this.dataIndex, safeLength);
            this.dataIndex += fragment.readableBytes();
            return fragment;
        }

        ByteBuf readMetadataFragment(int length) {
            Integer metadataLength = this.frame.getUnsafeMetadataLength();
            ByteBuf metadata = this.frame.getUnsafeMetadata();
            if (metadataLength == null || metadata == null) {
                throw new IllegalStateException("Cannot read metadata fragment with no metadata");
            }
            int safeLength = Math.min(length, metadataLength - this.metadataIndex);
            ByteBuf fragment = metadata.slice(this.metadataIndex, safeLength);
            this.metadataIndex += fragment.readableBytes();
            return fragment;
        }
    }
}

