/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoOperator;
import reactor.ipc.netty.ByteBufFlux;

public final class ByteBufMono
extends MonoOperator<ByteBuf, ByteBuf> {
    public final Mono<ByteBuffer> asByteBuffer() {
        return this.map(ByteBuf::nioBuffer);
    }

    public final Mono<byte[]> asByteArray() {
        return this.map(bb -> {
            byte[] bytes = new byte[bb.readableBytes()];
            bb.readBytes(bytes);
            return bytes;
        });
    }

    public final Mono<String> asString() {
        return this.asString(Charset.defaultCharset());
    }

    public final Mono<String> asString(Charset charset) {
        return this.map(s -> s.toString(charset));
    }

    public Mono<InputStream> asInputStream() {
        return this.map(ReleasingInputStream::new);
    }

    public ByteBufMono retain() {
        return new ByteBufMono(this.doOnNext(ByteBuf::retain));
    }

    @Override
    public void subscribe(CoreSubscriber<? super ByteBuf> actual) {
        this.source.subscribe(actual);
    }

    protected ByteBufMono(Mono<?> source) {
        super(source.map(ByteBufFlux.bytebufExtractor));
    }

    static final class ReleasingInputStream
    extends ByteBufInputStream {
        final ByteBuf bb;
        volatile int closed;
        static final AtomicIntegerFieldUpdater<ReleasingInputStream> CLOSE = AtomicIntegerFieldUpdater.newUpdater(ReleasingInputStream.class, "closed");

        ReleasingInputStream(ByteBuf bb) {
            super(bb.retain());
            this.bb = bb;
        }

        @Override
        public void close() throws IOException {
            if (CLOSE.compareAndSet(this, 0, 1)) {
                super.close();
                this.bb.release();
            }
        }
    }
}

