/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoOperator;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;

final class MonoPeekTerminal<T>
extends MonoOperator<T, T>
implements Fuseable {
    final BiConsumer<? super T, Throwable> onAfterTerminateCall;
    final BiConsumer<? super T, Throwable> onTerminateCall;
    final Consumer<? super T> onSuccessCall;

    MonoPeekTerminal(Mono<? extends T> source, @Nullable Consumer<? super T> onSuccessCall, @Nullable BiConsumer<? super T, Throwable> onTerminateCall, @Nullable BiConsumer<? super T, Throwable> onAfterTerminateCall) {
        super(source);
        this.onAfterTerminateCall = onAfterTerminateCall;
        this.onTerminateCall = onTerminateCall;
        this.onSuccessCall = onSuccessCall;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        if (actual instanceof Fuseable.ConditionalSubscriber) {
            this.source.subscribe(new MonoTerminalPeekSubscriber((Fuseable.ConditionalSubscriber)actual, this));
            return;
        }
        this.source.subscribe(new MonoTerminalPeekSubscriber<T>(actual, this));
    }

    static final class MonoTerminalPeekSubscriber<T>
    implements Fuseable.ConditionalSubscriber<T>,
    InnerOperator<T, T>,
    Fuseable.QueueSubscription<T> {
        final CoreSubscriber<? super T> actual;
        final Fuseable.ConditionalSubscriber<? super T> actualConditional;
        final MonoPeekTerminal<T> parent;
        Subscription s;
        Fuseable.QueueSubscription<T> queueSubscription;
        int sourceMode;
        volatile boolean done;
        boolean valued;

        MonoTerminalPeekSubscriber(Fuseable.ConditionalSubscriber<? super T> actual, MonoPeekTerminal<T> parent) {
            this.actualConditional = actual;
            this.actual = actual;
            this.parent = parent;
        }

        MonoTerminalPeekSubscriber(CoreSubscriber<? super T> actual, MonoPeekTerminal<T> parent) {
            this.actual = actual;
            this.actualConditional = null;
            this.parent = parent;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        public void request(long n) {
            this.s.request(n);
        }

        @Override
        public void cancel() {
            this.s.cancel();
        }

        @Override
        public void onSubscribe(Subscription s) {
            this.s = s;
            this.queueSubscription = Operators.as(s);
            this.actual.onSubscribe(this);
        }

        @Override
        public void onNext(T t) {
            if (this.sourceMode == 2) {
                this.actual.onNext(null);
            } else {
                if (this.done) {
                    Operators.onNextDropped(t, this.actual.currentContext());
                    return;
                }
                this.valued = true;
                if (this.parent.onTerminateCall != null) {
                    try {
                        this.parent.onTerminateCall.accept(t, null);
                    }
                    catch (Throwable e) {
                        this.onError(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()));
                        return;
                    }
                }
                if (this.parent.onSuccessCall != null) {
                    try {
                        this.parent.onSuccessCall.accept(t);
                    }
                    catch (Throwable e) {
                        this.onError(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()));
                        return;
                    }
                }
                this.actual.onNext(t);
                if (this.parent.onAfterTerminateCall != null) {
                    try {
                        this.parent.onAfterTerminateCall.accept(t, null);
                    }
                    catch (Throwable e) {
                        Operators.onErrorDropped(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()), this.actual.currentContext());
                    }
                }
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t, this.actual.currentContext());
                return false;
            }
            if (this.actualConditional == null) {
                this.onNext(t);
                return false;
            }
            this.valued = true;
            if (this.parent.onTerminateCall != null) {
                try {
                    this.parent.onTerminateCall.accept(t, null);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()));
                    return false;
                }
            }
            if (this.parent.onSuccessCall != null) {
                try {
                    this.parent.onSuccessCall.accept(t);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()));
                    return false;
                }
            }
            boolean r = this.actualConditional.tryOnNext(t);
            if (this.parent.onAfterTerminateCall != null) {
                try {
                    this.parent.onAfterTerminateCall.accept(t, null);
                }
                catch (Throwable e) {
                    Operators.onErrorDropped(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()), this.actual.currentContext());
                }
            }
            return r;
        }

        @Override
        public void onError(Throwable t) {
            block9: {
                if (this.done) {
                    Operators.onErrorDropped(t, this.actual.currentContext());
                    return;
                }
                this.done = true;
                if (!this.valued && this.parent.onTerminateCall != null) {
                    try {
                        this.parent.onTerminateCall.accept(null, t);
                    }
                    catch (Throwable e) {
                        t = Operators.onOperatorError(null, e, t, this.actual.currentContext());
                    }
                }
                try {
                    this.actual.onError(t);
                }
                catch (UnsupportedOperationException use) {
                    if (Exceptions.isErrorCallbackNotImplemented(use) || use.getCause() == t) break block9;
                    throw use;
                }
            }
            if (!this.valued && this.parent.onAfterTerminateCall != null) {
                try {
                    this.parent.onAfterTerminateCall.accept(null, t);
                }
                catch (Throwable e) {
                    Operators.onErrorDropped(Operators.onOperatorError(e, this.actual.currentContext()), this.actual.currentContext());
                }
            }
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            if (this.sourceMode == 0 && !this.valued) {
                if (this.parent.onTerminateCall != null) {
                    try {
                        this.parent.onTerminateCall.accept(null, null);
                    }
                    catch (Throwable e) {
                        this.onError(Operators.onOperatorError(this.s, e, this.actual.currentContext()));
                        return;
                    }
                }
                if (this.parent.onSuccessCall != null) {
                    try {
                        this.parent.onSuccessCall.accept(null);
                    }
                    catch (Throwable e) {
                        this.onError(Operators.onOperatorError(this.s, e, this.actual.currentContext()));
                        return;
                    }
                }
            }
            this.done = true;
            this.actual.onComplete();
            if (this.sourceMode == 0 && !this.valued && this.parent.onAfterTerminateCall != null) {
                try {
                    this.parent.onAfterTerminateCall.accept(null, null);
                }
                catch (Throwable e) {
                    Operators.onErrorDropped(Operators.onOperatorError(e, this.actual.currentContext()), this.actual.currentContext());
                }
            }
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        @Nullable
        public T poll() {
            boolean d = this.done;
            Object v = this.queueSubscription.poll();
            if (!this.valued && (v != null || d || this.sourceMode == 1)) {
                this.valued = true;
                if (this.parent.onTerminateCall != null) {
                    try {
                        this.parent.onTerminateCall.accept(v, null);
                    }
                    catch (Throwable e) {
                        throw Exceptions.propagate(Operators.onOperatorError(this.s, e, v, this.actual.currentContext()));
                    }
                }
                if (this.parent.onSuccessCall != null) {
                    try {
                        this.parent.onSuccessCall.accept(v);
                    }
                    catch (Throwable e) {
                        throw Exceptions.propagate(Operators.onOperatorError(this.s, e, v, this.actual.currentContext()));
                    }
                }
                if (this.parent.onAfterTerminateCall != null) {
                    try {
                        this.parent.onAfterTerminateCall.accept(v, null);
                    }
                    catch (Throwable t) {
                        Operators.onErrorDropped(Operators.onOperatorError(t, this.actual.currentContext()), this.actual.currentContext());
                    }
                }
            }
            return (T)v;
        }

        @Override
        public boolean isEmpty() {
            return this.queueSubscription.isEmpty();
        }

        @Override
        public void clear() {
            this.queueSubscription.clear();
        }

        @Override
        public int requestFusion(int requestedMode) {
            int m = this.queueSubscription == null ? 0 : ((requestedMode & 4) != 0 ? 0 : this.queueSubscription.requestFusion(requestedMode));
            this.sourceMode = m;
            return m;
        }

        @Override
        public int size() {
            return this.queueSubscription == null ? 0 : this.queueSubscription.size();
        }
    }
}

