/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.methods;

import io.scalecube.services.Reflect;
import io.scalecube.services.methods.MethodInfo;
import io.scalecube.services.methods.ServiceMethodInvoker;
import io.scalecube.services.methods.ServiceMethodRegistry;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ServiceMethodRegistryImpl
implements ServiceMethodRegistry {
    private final ConcurrentMap<String, ServiceMethodInvoker> methodInvokers = new ConcurrentHashMap<String, ServiceMethodInvoker>();

    @Override
    public void registerService(Object serviceInstance) {
        Reflect.serviceInterfaces(serviceInstance).forEach(serviceInterface -> Reflect.serviceMethods(serviceInterface).forEach((key, method) -> {
            Reflect.validateMethodOrThrow(method);
            MethodInfo methodInfo = new MethodInfo(Reflect.serviceName(serviceInterface), Reflect.methodName(method), Reflect.parameterizedReturnType(method), Reflect.communicationMode(method), method.getParameterCount(), Reflect.requestType(method));
            this.methodInvokers.put(methodInfo.qualifier(), new ServiceMethodInvoker((Method)method, serviceInstance, methodInfo));
        }));
    }

    @Override
    public boolean containsInvoker(String qualifier) {
        return this.methodInvokers.containsKey(qualifier);
    }

    @Override
    public ServiceMethodInvoker getInvoker(String qualifier) {
        return (ServiceMethodInvoker)this.methodInvokers.get(qualifier);
    }
}

