/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.gateway;

import io.scalecube.services.gateway.Gateway;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;

public final class GatewayConfig {
    private final String name;
    private final Class<? extends Gateway> gatewayClass;
    private final Map<String, String> options;
    private final int port;
    private final ExecutorService executorService;

    private GatewayConfig(Builder builder) {
        this.name = builder.name;
        this.gatewayClass = builder.gatewayClass;
        this.port = builder.port;
        this.options = new HashMap<String, String>(builder.options);
        this.executorService = builder.executorService;
    }

    public String name() {
        return this.name;
    }

    public Class<? extends Gateway> gatewayClass() {
        return this.gatewayClass;
    }

    public int port() {
        return this.port;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    public Optional<String> get(String key) {
        return Optional.ofNullable(this.options.get(key));
    }

    public static Builder from(Builder other) {
        return new Builder(other);
    }

    public static Builder from(GatewayConfig config) {
        return new Builder(config);
    }

    public static Builder builder(String name, Class<? extends Gateway> gatewayClass) {
        return new Builder(name, gatewayClass);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GatewayConfig{");
        sb.append("name='").append(this.name).append("'");
        sb.append(", gatewayClass=").append(this.gatewayClass.getName());
        sb.append(", options=").append(this.options);
        sb.append(", port=").append(this.port);
        sb.append(", executorService=").append(this.executorService);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GatewayConfig that = (GatewayConfig)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.gatewayClass, that.gatewayClass);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.gatewayClass);
    }

    public static class Builder {
        private final String name;
        private final Class<? extends Gateway> gatewayClass;
        private Map<String, String> options = new HashMap<String, String>();
        private int port = 0;
        private ExecutorService executorService;

        private Builder(String name, Class<? extends Gateway> gatewayClass) {
            this.name = name;
            this.gatewayClass = gatewayClass;
        }

        private Builder(Builder other) {
            this.name = other.name;
            this.gatewayClass = other.gatewayClass;
            this.options = new HashMap<String, String>(other.options);
            this.port = other.port;
            this.executorService = other.executorService;
        }

        private Builder(GatewayConfig config) {
            this.name = config.name;
            this.gatewayClass = config.gatewayClass;
            this.options = new HashMap<String, String>(config.options);
            this.port = config.port;
            this.executorService = config.executorService;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder addOption(String key, String value) {
            this.options.put(key, value);
            return this;
        }

        public Builder addOptions(Map<String, String> options) {
            this.options.putAll(options);
            return this;
        }

        public GatewayConfig build() {
            return new GatewayConfig(this);
        }
    }
}

