/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services;

import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.UnicastProcessor;

public final class HeadAndTail<T> {
    private final T head;
    private final Publisher<T> tail;

    private HeadAndTail(T head, Publisher<T> tail) {
        this.head = head;
        this.tail = tail;
    }

    public static <U> Publisher<HeadAndTail<U>> createFrom(Publisher<U> publisher) {
        AtomicBoolean first = new AtomicBoolean(true);
        UnicastProcessor tail = UnicastProcessor.create();
        UnicastProcessor firstResult = UnicastProcessor.create();
        return Flux.from(publisher).doOnComplete(tail::onComplete).doOnError(tail::onError).flatMap(message -> {
            if (first.compareAndSet(true, false)) {
                firstResult.onNext(new HeadAndTail<Object>(message, tail));
                firstResult.onComplete();
                return firstResult;
            }
            tail.onNext(message);
            return Flux.empty();
        });
    }

    public T head() {
        return this.head;
    }

    public Publisher<T> tail() {
        return this.tail;
    }
}

