/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster;

import io.scalecube.Preconditions;
import io.scalecube.cluster.fdetector.FailureDetectorConfig;
import io.scalecube.cluster.gossip.GossipConfig;
import io.scalecube.cluster.membership.MembershipConfig;
import io.scalecube.transport.Address;
import io.scalecube.transport.TransportConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ClusterConfig
implements FailureDetectorConfig,
GossipConfig,
MembershipConfig {
    public static final String DEFAULT_SYNC_GROUP = "default";
    public static final int DEFAULT_SYNC_INTERVAL = 30000;
    public static final int DEFAULT_SYNC_TIMEOUT = 3000;
    public static final int DEFAULT_SUSPICION_MULT = 5;
    public static final int DEFAULT_PING_INTERVAL = 1000;
    public static final int DEFAULT_PING_TIMEOUT = 500;
    public static final int DEFAULT_PING_REQ_MEMBERS = 3;
    public static final long DEFAULT_GOSSIP_INTERVAL = 200L;
    public static final int DEFAULT_GOSSIP_FANOUT = 3;
    public static final int DEFAULT_GOSSIP_REPEAT_MULT = 3;
    public static final int DEFAULT_WAN_SUSPICION_MULT = 6;
    public static final int DEFAULT_WAN_SYNC_INTERVAL = 60000;
    public static final int DEFAULT_WAN_PING_TIMEOUT = 3000;
    public static final int DEFAULT_WAN_PING_INTERVAL = 5000;
    public static final int DEFAULT_WAN_GOSSIP_FANOUT = 4;
    public static final int DEFAULT_WAN_CONNECT_TIMEOUT = 10000;
    public static final int DEFAULT_LOCAL_SUSPICION_MULT = 3;
    public static final int DEFAULT_LOCAL_SYNC_INTERVAL = 15000;
    public static final int DEFAULT_LOCAL_PING_TIMEOUT = 200;
    public static final int DEFAULT_LOCAL_PING_INTERVAL = 1000;
    public static final int DEFAULT_LOCAL_GOSSIP_REPEAT_MULT = 2;
    public static final int DEFAULT_LOCAL_PING_REQ_MEMBERS = 1;
    public static final int DEFAULT_LOCAL_GOSSIP_INTERVAL = 100;
    public static final int DEFAULT_LOCAL_CONNECT_TIMEOUT = 1000;
    public static final String DEFAULT_MEMBER_HOST = null;
    public static final Integer DEFAULT_MEMBER_PORT = null;
    private final List<Address> seedMembers;
    private final Map<String, String> metadata;
    private final int syncInterval;
    private final int syncTimeout;
    private final int suspicionMult;
    private final String syncGroup;
    private final int pingInterval;
    private final int pingTimeout;
    private final int pingReqMembers;
    private final long gossipInterval;
    private final int gossipFanout;
    private final int gossipRepeatMult;
    private final TransportConfig transportConfig;
    private final String memberHost;
    private final Integer memberPort;

    private ClusterConfig(Builder builder) {
        this.seedMembers = Collections.unmodifiableList(builder.seedMembers);
        this.metadata = Collections.unmodifiableMap(builder.metadata);
        this.syncInterval = builder.syncInterval;
        this.syncTimeout = builder.syncTimeout;
        this.syncGroup = builder.syncGroup;
        this.suspicionMult = builder.suspicionMult;
        this.pingInterval = builder.pingInterval;
        this.pingTimeout = builder.pingTimeout;
        this.pingReqMembers = builder.pingReqMembers;
        this.gossipFanout = builder.gossipFanout;
        this.gossipInterval = builder.gossipInterval;
        this.gossipRepeatMult = builder.gossipRepeatMult;
        this.transportConfig = builder.transportConfigBuilder.build();
        this.memberHost = builder.memberHost;
        this.memberPort = builder.memberPort;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ClusterConfig defaultConfig() {
        return ClusterConfig.builder().build();
    }

    public static ClusterConfig defaultLanConfig() {
        return ClusterConfig.defaultConfig();
    }

    public static ClusterConfig defaultWanConfig() {
        return ClusterConfig.builder().suspicionMult(6).syncInterval(60000).pingTimeout(3000).pingInterval(5000).gossipFanout(4).connectTimeout(10000).build();
    }

    public static ClusterConfig defaultLocalConfig() {
        return ClusterConfig.builder().suspicionMult(3).syncInterval(15000).pingTimeout(200).pingInterval(1000).gossipRepeatMult(2).pingReqMembers(1).gossipInterval(100L).connectTimeout(1000).build();
    }

    @Override
    public List<Address> getSeedMembers() {
        return this.seedMembers;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public int getSyncInterval() {
        return this.syncInterval;
    }

    @Override
    public int getSyncTimeout() {
        return this.syncTimeout;
    }

    @Override
    public int getSuspicionMult() {
        return this.suspicionMult;
    }

    @Override
    public String getSyncGroup() {
        return this.syncGroup;
    }

    @Override
    public int getPingInterval() {
        return this.pingInterval;
    }

    @Override
    public int getPingTimeout() {
        return this.pingTimeout;
    }

    @Override
    public int getPingReqMembers() {
        return this.pingReqMembers;
    }

    @Override
    public int getGossipFanout() {
        return this.gossipFanout;
    }

    @Override
    public long getGossipInterval() {
        return this.gossipInterval;
    }

    @Override
    public int getGossipRepeatMult() {
        return this.gossipRepeatMult;
    }

    public TransportConfig getTransportConfig() {
        return this.transportConfig;
    }

    @Override
    public String getMemberHost() {
        return this.memberHost;
    }

    @Override
    public Integer getMemberPort() {
        return this.memberPort;
    }

    public String toString() {
        return "ClusterConfig{seedMembers=" + this.seedMembers + ", metadata=" + this.metadata + ", syncInterval=" + this.syncInterval + ", syncTimeout=" + this.syncTimeout + ", suspicionMult=" + this.suspicionMult + ", syncGroup='" + this.syncGroup + '\'' + ", pingInterval=" + this.pingInterval + ", pingTimeout=" + this.pingTimeout + ", pingReqMembers=" + this.pingReqMembers + ", gossipInterval=" + this.gossipInterval + ", gossipFanout=" + this.gossipFanout + ", gossipRepeatMult=" + this.gossipRepeatMult + ", transportConfig=" + this.transportConfig + ", memberHost=" + this.memberHost + ", memberPort=" + this.memberPort + '}';
    }

    public static final class Builder {
        private List<Address> seedMembers = Collections.emptyList();
        private Map<String, String> metadata = new HashMap<String, String>();
        private int syncInterval = 30000;
        private int syncTimeout = 3000;
        private String syncGroup = "default";
        private int suspicionMult = 5;
        private int pingInterval = 1000;
        private int pingTimeout = 500;
        private int pingReqMembers = 3;
        private long gossipInterval = 200L;
        private int gossipFanout = 3;
        private int gossipRepeatMult = 3;
        private TransportConfig.Builder transportConfigBuilder = TransportConfig.builder();
        private String memberHost = DEFAULT_MEMBER_HOST;
        private Integer memberPort = DEFAULT_MEMBER_PORT;

        private Builder() {
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = new HashMap<String, String>(metadata);
            return this;
        }

        public Builder addMetadata(String key, String value) {
            this.metadata.put(key, value);
            return this;
        }

        public Builder addMetadata(Map<String, String> metadata) {
            this.metadata.putAll(metadata);
            return this;
        }

        public Builder seedMembers(Address ... seedMembers) {
            this.seedMembers = Arrays.asList(seedMembers);
            return this;
        }

        public Builder seedMembers(List<Address> seedMembers) {
            this.seedMembers = new ArrayList<Address>(seedMembers);
            return this;
        }

        public Builder syncInterval(int syncInterval) {
            this.syncInterval = syncInterval;
            return this;
        }

        public Builder syncTimeout(int syncTimeout) {
            this.syncTimeout = syncTimeout;
            return this;
        }

        public Builder suspicionMult(int suspicionMult) {
            this.suspicionMult = suspicionMult;
            return this;
        }

        public Builder syncGroup(String syncGroup) {
            this.syncGroup = syncGroup;
            return this;
        }

        public Builder pingInterval(int pingInterval) {
            this.pingInterval = pingInterval;
            return this;
        }

        public Builder pingTimeout(int pingTimeout) {
            this.pingTimeout = pingTimeout;
            return this;
        }

        public Builder pingReqMembers(int pingReqMembers) {
            this.pingReqMembers = pingReqMembers;
            return this;
        }

        public Builder gossipInterval(long gossipInterval) {
            this.gossipInterval = gossipInterval;
            return this;
        }

        public Builder gossipFanout(int gossipFanout) {
            this.gossipFanout = gossipFanout;
            return this;
        }

        public Builder gossipRepeatMult(int gossipRepeatMult) {
            this.gossipRepeatMult = gossipRepeatMult;
            return this;
        }

        public Builder transportConfig(TransportConfig transportConfig) {
            this.transportConfigBuilder.fillFrom(transportConfig);
            return this;
        }

        public Builder listenAddress(String listenAddress) {
            this.transportConfigBuilder.listenAddress(listenAddress);
            return this;
        }

        public Builder listenInterface(String listenInterface) {
            this.transportConfigBuilder.listenInterface(listenInterface);
            return this;
        }

        public Builder port(int port) {
            this.transportConfigBuilder.port(port);
            return this;
        }

        public Builder portAutoIncrement(boolean portAutoIncrement) {
            this.transportConfigBuilder.portAutoIncrement(portAutoIncrement);
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.transportConfigBuilder.connectTimeout(connectTimeout);
            return this;
        }

        public Builder useNetworkEmulator(boolean useNetworkEmulator) {
            this.transportConfigBuilder.useNetworkEmulator(useNetworkEmulator);
            return this;
        }

        public Builder memberHost(String memberHost) {
            this.memberHost = memberHost;
            return this;
        }

        public Builder memberPort(Integer memberPort) {
            this.memberPort = memberPort;
            return this;
        }

        public ClusterConfig build() {
            Preconditions.checkState(this.pingTimeout < this.pingInterval, "Ping timeout can't be bigger than ping interval");
            return new ClusterConfig(this);
        }
    }
}

