/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube;

import java.util.Objects;

public final class Preconditions {
    private Preconditions() {
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
    }

    public static void checkState(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalStateException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static <T> T checkNotNull(T reference) {
        Objects.requireNonNull(reference);
        return reference;
    }

    public static <T> T checkNotNull(T reference, String errorMessage) {
        Objects.requireNonNull(reference, errorMessage);
        return reference;
    }

    public static <T> T checkNotNull(T reference, String errorMessageTemplate, Object ... errorMessageArgs) {
        Objects.requireNonNull(reference, Preconditions.format(errorMessageTemplate, errorMessageArgs));
        return reference;
    }

    private static String format(String template, Object ... args) {
        int placeholderStart;
        String template0 = String.valueOf(template);
        StringBuilder builder = new StringBuilder(template0.length() + 16 * args.length);
        int templateStart = 0;
        int idx = 0;
        while (idx < args.length && (placeholderStart = template0.indexOf("%s", templateStart)) != -1) {
            builder.append(template0.substring(templateStart, placeholderStart));
            builder.append(args[idx++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template0.substring(templateStart));
        if (idx < args.length) {
            builder.append(" [");
            builder.append(args[idx++]);
            while (idx < args.length) {
                builder.append(", ");
                builder.append(args[idx++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }
}

