/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.resume;

import io.netty.buffer.ByteBufUtil;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;

public final class ResumeToken {
    private final byte[] resumeToken;

    protected ResumeToken(byte[] resumeToken) {
        this.resumeToken = resumeToken;
    }

    public static ResumeToken bytes(byte[] token) {
        return new ResumeToken(token);
    }

    public static ResumeToken generate() {
        return new ResumeToken(ResumeToken.getBytesFromUUID(UUID.randomUUID()));
    }

    static byte[] getBytesFromUUID(UUID uuid) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }

    public int hashCode() {
        return Arrays.hashCode(this.resumeToken);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResumeToken) {
            return Arrays.equals(this.resumeToken, ((ResumeToken)obj).resumeToken);
        }
        return false;
    }

    public String toString() {
        return ByteBufUtil.hexDump(this.resumeToken);
    }

    public byte[] toByteArray() {
        return this.resumeToken;
    }
}

