/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.framing;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.Recycler;
import io.rsocket.framing.AbstractRecyclableFrame;
import io.rsocket.framing.FrameType;
import io.rsocket.util.RecyclerFactory;
import java.util.Objects;

public final class ResumeOkFrame
extends AbstractRecyclableFrame<ResumeOkFrame> {
    private static final int OFFSET_LAST_RECEIVED_CLIENT_POSITION = 2;
    private static final Recycler<ResumeOkFrame> RECYCLER = RecyclerFactory.createRecycler(ResumeOkFrame::new);

    private ResumeOkFrame(Recycler.Handle<ResumeOkFrame> handle) {
        super(handle);
    }

    public static ResumeOkFrame createResumeOkFrame(ByteBuf byteBuf) {
        Objects.requireNonNull(byteBuf, "byteBuf must not be null");
        return (ResumeOkFrame)RECYCLER.get().setByteBuf(byteBuf.retain());
    }

    public static ResumeOkFrame createResumeOkFrame(ByteBufAllocator byteBufAllocator, long lastReceivedClientPosition) {
        ByteBuf byteBuf = ResumeOkFrame.createFrameTypeAndFlags(byteBufAllocator, FrameType.RESUME_OK).writeLong(lastReceivedClientPosition);
        return (ResumeOkFrame)RECYCLER.get().setByteBuf(byteBuf);
    }

    public long getLastReceivedClientPosition() {
        return this.getByteBuf().getLong(2);
    }

    public String toString() {
        return "ResumeOkFrame{lastReceivedClientPosition=" + this.getLastReceivedClientPosition() + '}';
    }
}

