/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.framing;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import io.rsocket.framing.AbstractRecyclableFragmentableFrame;
import io.rsocket.framing.FrameType;
import io.rsocket.util.NumberUtils;
import io.rsocket.util.RecyclerFactory;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public final class RequestStreamFrame
extends AbstractRecyclableFragmentableFrame<RequestStreamFrame> {
    private static final int OFFSET_INITIAL_REQUEST_N = 2;
    private static final int OFFSET_METADATA_LENGTH = 6;
    private static final Recycler<RequestStreamFrame> RECYCLER = RecyclerFactory.createRecycler(RequestStreamFrame::new);

    private RequestStreamFrame(Recycler.Handle<RequestStreamFrame> handle) {
        super(handle);
    }

    public static RequestStreamFrame createRequestStreamFrame(ByteBuf byteBuf) {
        Objects.requireNonNull(byteBuf, "byteBuf must not be null");
        return (RequestStreamFrame)RECYCLER.get().setByteBuf(byteBuf.retain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RequestStreamFrame createRequestStreamFrame(ByteBufAllocator byteBufAllocator, boolean follows, int initialRequestN, @Nullable String metadata, @Nullable String data) {
        ByteBuf metadataByteBuf = RequestStreamFrame.getUtf8AsByteBuf(metadata);
        ByteBuf dataByteBuf = RequestStreamFrame.getUtf8AsByteBuf(data);
        try {
            RequestStreamFrame requestStreamFrame = RequestStreamFrame.createRequestStreamFrame(byteBufAllocator, follows, initialRequestN, metadataByteBuf, dataByteBuf);
            return requestStreamFrame;
        }
        finally {
            ReferenceCountUtil.release(metadataByteBuf);
            ReferenceCountUtil.release(dataByteBuf);
        }
    }

    public static RequestStreamFrame createRequestStreamFrame(ByteBufAllocator byteBufAllocator, boolean follows, int initialRequestN, @Nullable ByteBuf metadata, @Nullable ByteBuf data) {
        NumberUtils.requirePositive(initialRequestN, "initialRequestN must be positive");
        ByteBuf byteBuf = RequestStreamFrame.createFrameTypeAndFlags(byteBufAllocator, FrameType.REQUEST_STREAM);
        if (follows) {
            byteBuf = RequestStreamFrame.setFollowsFlag(byteBuf);
        }
        byteBuf = byteBuf.writeInt(initialRequestN);
        byteBuf = RequestStreamFrame.appendMetadata(byteBufAllocator, byteBuf, metadata);
        byteBuf = RequestStreamFrame.appendData(byteBuf, data);
        return (RequestStreamFrame)RECYCLER.get().setByteBuf(byteBuf);
    }

    @Override
    public RequestStreamFrame createFragment(ByteBufAllocator byteBufAllocator, @Nullable ByteBuf metadata, @Nullable ByteBuf data) {
        return RequestStreamFrame.createRequestStreamFrame(byteBufAllocator, true, this.getInitialRequestN(), metadata, data);
    }

    @Override
    public RequestStreamFrame createNonFragment(ByteBufAllocator byteBufAllocator, @Nullable ByteBuf metadata, @Nullable ByteBuf data) {
        return RequestStreamFrame.createRequestStreamFrame(byteBufAllocator, false, this.getInitialRequestN(), metadata, data);
    }

    public int getInitialRequestN() {
        return this.getByteBuf().getInt(2);
    }

    @Override
    public ByteBuf getUnsafeData() {
        return this.getData(6);
    }

    @Override
    @Nullable
    public ByteBuf getUnsafeMetadata() {
        return this.getMetadata(6);
    }

    public String toString() {
        return "RequestStreamFrame{follows=" + this.isFollowsFlagSet() + ", initialRequestN=" + this.getInitialRequestN() + ", metadata=" + this.mapMetadata(ByteBufUtil::hexDump) + ", data=" + this.mapData(ByteBufUtil::hexDump) + '}';
    }
}

