/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.framing;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import io.rsocket.framing.AbstractRecyclableFragmentableFrame;
import io.rsocket.framing.FrameType;
import io.rsocket.util.RecyclerFactory;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public final class PayloadFrame
extends AbstractRecyclableFragmentableFrame<PayloadFrame> {
    private static final int FLAG_COMPLETE = 64;
    private static final int FLAG_NEXT = 32;
    private static final int OFFSET_METADATA_LENGTH = 2;
    private static final Recycler<PayloadFrame> RECYCLER = RecyclerFactory.createRecycler(PayloadFrame::new);

    private PayloadFrame(Recycler.Handle<PayloadFrame> handle) {
        super(handle);
    }

    public static PayloadFrame createPayloadFrame(ByteBuf byteBuf) {
        Objects.requireNonNull(byteBuf, "byteBuf must not be null");
        return (PayloadFrame)RECYCLER.get().setByteBuf(byteBuf.retain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PayloadFrame createPayloadFrame(ByteBufAllocator byteBufAllocator, boolean follows, boolean complete, @Nullable String metadata, @Nullable String data) {
        ByteBuf metadataByteBuf = PayloadFrame.getUtf8AsByteBuf(metadata);
        ByteBuf dataByteBuf = PayloadFrame.getUtf8AsByteBuf(data);
        try {
            PayloadFrame payloadFrame = PayloadFrame.createPayloadFrame(byteBufAllocator, follows, complete, metadataByteBuf, dataByteBuf);
            return payloadFrame;
        }
        finally {
            ReferenceCountUtil.release(metadataByteBuf);
            ReferenceCountUtil.release(dataByteBuf);
        }
    }

    public static PayloadFrame createPayloadFrame(ByteBufAllocator byteBufAllocator, boolean follows, boolean complete, @Nullable ByteBuf metadata, @Nullable ByteBuf data) {
        if (!complete && data == null) {
            throw new IllegalArgumentException("Payload frame must either be complete, have data, or both");
        }
        ByteBuf byteBuf = PayloadFrame.createFrameTypeAndFlags(byteBufAllocator, FrameType.PAYLOAD);
        if (follows) {
            byteBuf = PayloadFrame.setFollowsFlag(byteBuf);
        }
        if (complete) {
            byteBuf = PayloadFrame.setFlag(byteBuf, 64);
        }
        byteBuf = PayloadFrame.appendMetadata(byteBufAllocator, byteBuf, metadata);
        if (data != null) {
            byteBuf = PayloadFrame.setFlag(byteBuf, 32);
        }
        byteBuf = PayloadFrame.appendData(byteBuf, data);
        return (PayloadFrame)RECYCLER.get().setByteBuf(byteBuf);
    }

    @Override
    public PayloadFrame createFragment(ByteBufAllocator byteBufAllocator, @Nullable ByteBuf metadata, @Nullable ByteBuf data) {
        return PayloadFrame.createPayloadFrame(byteBufAllocator, true, this.isCompleteFlagSet(), metadata, data);
    }

    @Override
    public PayloadFrame createNonFragment(ByteBufAllocator byteBufAllocator, @Nullable ByteBuf metadata, @Nullable ByteBuf data) {
        return PayloadFrame.createPayloadFrame(byteBufAllocator, false, this.isCompleteFlagSet(), metadata, data);
    }

    @Override
    public ByteBuf getUnsafeData() {
        return this.getData(2);
    }

    @Override
    @Nullable
    public ByteBuf getUnsafeMetadata() {
        return this.getMetadata(2);
    }

    public boolean isCompleteFlagSet() {
        return this.isFlagSet(64);
    }

    public boolean isNextFlagSet() {
        return this.isFlagSet(32);
    }

    public String toString() {
        return "PayloadFrame{follows=" + this.isFollowsFlagSet() + ", complete=" + this.isCompleteFlagSet() + ", next=" + this.isNextFlagSet() + ", metadata=" + this.mapMetadata(ByteBufUtil::hexDump) + ", data=" + this.mapData(ByteBufUtil::hexDump) + '}';
    }
}

