/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.framing;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import io.rsocket.framing.AbstractRecyclableDataFrame;
import io.rsocket.framing.FrameType;
import io.rsocket.util.RecyclerFactory;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public final class ErrorFrame
extends AbstractRecyclableDataFrame<ErrorFrame> {
    private static final int OFFSET_ERROR_CODE = 2;
    private static final int OFFSET_DATA = 6;
    private static final Recycler<ErrorFrame> RECYCLER = RecyclerFactory.createRecycler(ErrorFrame::new);

    private ErrorFrame(Recycler.Handle<ErrorFrame> handle) {
        super(handle);
    }

    public static ErrorFrame createErrorFrame(ByteBuf byteBuf) {
        Objects.requireNonNull(byteBuf, "byteBuf must not be null");
        return (ErrorFrame)RECYCLER.get().setByteBuf(byteBuf.retain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ErrorFrame createErrorFrame(ByteBufAllocator byteBufAllocator, int errorCode, @Nullable String data) {
        ByteBuf dataByteBuf = ErrorFrame.getUtf8AsByteBuf(data);
        try {
            ErrorFrame errorFrame = ErrorFrame.createErrorFrame(byteBufAllocator, errorCode, dataByteBuf);
            return errorFrame;
        }
        finally {
            ReferenceCountUtil.release(dataByteBuf);
        }
    }

    public static ErrorFrame createErrorFrame(ByteBufAllocator byteBufAllocator, int errorCode, @Nullable ByteBuf data) {
        ByteBuf byteBuf = ErrorFrame.createFrameTypeAndFlags(byteBufAllocator, FrameType.ERROR).writeInt(errorCode);
        byteBuf = ErrorFrame.appendData(byteBuf, data);
        return (ErrorFrame)RECYCLER.get().setByteBuf(byteBuf);
    }

    public int getErrorCode() {
        return this.getByteBuf().getInt(2);
    }

    @Override
    public ByteBuf getUnsafeData() {
        return this.getData(6);
    }

    public String toString() {
        return "ErrorFrame{errorCode=" + this.getErrorCode() + ", data=" + this.mapData(ByteBufUtil::hexDump) + '}';
    }
}

