/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.rsocket.Frame;
import io.rsocket.frame.ErrorFrameFlyweight;
import io.rsocket.frame.KeepaliveFrameFlyweight;
import io.rsocket.frame.LeaseFrameFlyweight;
import io.rsocket.frame.RequestFrameFlyweight;
import io.rsocket.frame.RequestNFrameFlyweight;
import io.rsocket.frame.SetupFrameFlyweight;
import io.rsocket.framing.FrameType;
import javax.annotation.Nullable;

public class FrameHeaderFlyweight {
    public static final int FRAME_HEADER_LENGTH;
    private static final int FRAME_TYPE_BITS = 6;
    private static final int FRAME_TYPE_SHIFT = 10;
    private static final int FRAME_FLAGS_MASK = 1023;
    public static final int FRAME_LENGTH_SIZE = 3;
    public static final int FRAME_LENGTH_MASK = 0xFFFFFF;
    private static final int FRAME_LENGTH_FIELD_OFFSET;
    private static final int FRAME_TYPE_AND_FLAGS_FIELD_OFFSET;
    private static final int STREAM_ID_FIELD_OFFSET;
    private static final int PAYLOAD_OFFSET;
    public static final int FLAGS_I = 512;
    public static final int FLAGS_M = 256;
    public static final int FLAGS_F = 128;
    public static final int FLAGS_C = 64;
    public static final int FLAGS_N = 32;

    private FrameHeaderFlyweight() {
    }

    public static int computeFrameHeaderLength(FrameType frameType, @Nullable Integer metadataLength, int dataLength) {
        return PAYLOAD_OFFSET + FrameHeaderFlyweight.computeMetadataLength(frameType, metadataLength) + dataLength;
    }

    public static int encodeFrameHeader(ByteBuf byteBuf, int frameLength, int flags, FrameType frameType, int streamId) {
        if ((frameLength & 0xFF000000) != 0) {
            throw new IllegalArgumentException("Frame length is larger than 24 bits");
        }
        FrameHeaderFlyweight.encodeLength(byteBuf, FRAME_LENGTH_FIELD_OFFSET, frameLength - 3);
        byteBuf.setInt(STREAM_ID_FIELD_OFFSET, streamId);
        short typeAndFlags = (short)(frameType.getEncodedType() << 10 | (short)flags);
        byteBuf.setShort(FRAME_TYPE_AND_FLAGS_FIELD_OFFSET, typeAndFlags);
        return FRAME_HEADER_LENGTH;
    }

    public static int encodeMetadata(ByteBuf byteBuf, FrameType frameType, int metadataOffset, @Nullable ByteBuf metadata) {
        int length = 0;
        if (metadata != null) {
            int metadataLength = metadata.readableBytes();
            int typeAndFlags = byteBuf.getShort(FRAME_TYPE_AND_FLAGS_FIELD_OFFSET);
            byteBuf.setShort(FRAME_TYPE_AND_FLAGS_FIELD_OFFSET, (short)(typeAndFlags |= 0x100));
            if (FrameHeaderFlyweight.hasMetadataLengthField(frameType)) {
                FrameHeaderFlyweight.encodeLength(byteBuf, metadataOffset, metadataLength);
                length += 3;
            }
            byteBuf.setBytes(metadataOffset + length, metadata, metadata.readerIndex(), metadataLength);
            length += metadataLength;
        }
        return length;
    }

    public static int encodeData(ByteBuf byteBuf, int dataOffset, ByteBuf data) {
        int length = 0;
        int dataLength = data.readableBytes();
        if (0 < dataLength) {
            byteBuf.setBytes(dataOffset, data, data.readerIndex(), dataLength);
            length += dataLength;
        }
        return length;
    }

    public static int encode(ByteBuf byteBuf, int streamId, int flags, FrameType frameType, @Nullable ByteBuf metadata, ByteBuf data) {
        FrameType outFrameType;
        if (Frame.isFlagSet(flags, 256) != (metadata != null)) {
            throw new IllegalStateException("bad value for metadata flag");
        }
        int frameLength = FrameHeaderFlyweight.computeFrameHeaderLength(frameType, metadata != null ? Integer.valueOf(metadata.readableBytes()) : null, data.readableBytes());
        switch (frameType) {
            case PAYLOAD: {
                throw new IllegalArgumentException("Don't encode raw PAYLOAD frames, use NEXT_COMPLETE, COMPLETE or NEXT");
            }
            case NEXT_COMPLETE: {
                outFrameType = FrameType.PAYLOAD;
                flags |= 0x60;
                break;
            }
            case COMPLETE: {
                outFrameType = FrameType.PAYLOAD;
                flags |= 0x40;
                break;
            }
            case NEXT: {
                outFrameType = FrameType.PAYLOAD;
                flags |= 0x20;
                break;
            }
            default: {
                outFrameType = frameType;
            }
        }
        int length = FrameHeaderFlyweight.encodeFrameHeader(byteBuf, frameLength, flags, outFrameType, streamId);
        length += FrameHeaderFlyweight.encodeMetadata(byteBuf, frameType, length, metadata);
        length += FrameHeaderFlyweight.encodeData(byteBuf, length, data);
        return length;
    }

    public static int flags(ByteBuf byteBuf) {
        short typeAndFlags = byteBuf.getShort(FRAME_TYPE_AND_FLAGS_FIELD_OFFSET);
        return typeAndFlags & 0x3FF;
    }

    public static FrameType frameType(ByteBuf byteBuf) {
        short typeAndFlags = byteBuf.getShort(FRAME_TYPE_AND_FLAGS_FIELD_OFFSET);
        FrameType result = FrameType.fromEncodedType(typeAndFlags >> 10);
        if (FrameType.PAYLOAD == result) {
            boolean next;
            int flags = typeAndFlags & 0x3FF;
            boolean complete = 64 == (flags & 0x40);
            boolean bl = next = 32 == (flags & 0x20);
            if (next && complete) {
                result = FrameType.NEXT_COMPLETE;
            } else if (complete) {
                result = FrameType.COMPLETE;
            } else if (next) {
                result = FrameType.NEXT;
            } else {
                throw new IllegalArgumentException("Payload must set either or both of NEXT and COMPLETE.");
            }
        }
        return result;
    }

    public static int streamId(ByteBuf byteBuf) {
        return byteBuf.getInt(STREAM_ID_FIELD_OFFSET);
    }

    public static ByteBuf sliceFrameData(ByteBuf byteBuf) {
        FrameType frameType = FrameHeaderFlyweight.frameType(byteBuf);
        int frameLength = FrameHeaderFlyweight.frameLength(byteBuf);
        int dataLength = FrameHeaderFlyweight.dataLength(byteBuf, frameType);
        int dataOffset = FrameHeaderFlyweight.dataOffset(byteBuf, frameType, frameLength);
        ByteBuf result = Unpooled.EMPTY_BUFFER;
        if (0 < dataLength) {
            result = byteBuf.slice(dataOffset, dataLength);
        }
        return result;
    }

    @Nullable
    public static ByteBuf sliceFrameMetadata(ByteBuf byteBuf) {
        int frameLength;
        FrameType frameType = FrameHeaderFlyweight.frameType(byteBuf);
        Integer metadataLength = FrameHeaderFlyweight.metadataLength(byteBuf, frameType, frameLength = FrameHeaderFlyweight.frameLength(byteBuf));
        if (metadataLength == null) {
            return null;
        }
        int metadataOffset = FrameHeaderFlyweight.metadataOffset(byteBuf);
        if (FrameHeaderFlyweight.hasMetadataLengthField(frameType)) {
            metadataOffset += 3;
        }
        ByteBuf result = Unpooled.EMPTY_BUFFER;
        if (0 < metadataLength) {
            result = byteBuf.slice(metadataOffset, metadataLength);
        }
        return result;
    }

    public static int frameLength(ByteBuf byteBuf) {
        return FrameHeaderFlyweight.decodeLength(byteBuf, FRAME_LENGTH_FIELD_OFFSET) + 3;
    }

    private static int metadataFieldLength(ByteBuf byteBuf, FrameType frameType, int frameLength) {
        return FrameHeaderFlyweight.computeMetadataLength(frameType, FrameHeaderFlyweight.metadataLength(byteBuf, frameType, frameLength));
    }

    @Nullable
    public static Integer metadataLength(ByteBuf byteBuf, FrameType frameType, int frameLength) {
        if (!FrameHeaderFlyweight.hasMetadataLengthField(frameType)) {
            return frameLength - FrameHeaderFlyweight.metadataOffset(byteBuf);
        }
        return FrameHeaderFlyweight.decodeMetadataLength(byteBuf, FrameHeaderFlyweight.metadataOffset(byteBuf));
    }

    @Nullable
    static Integer decodeMetadataLength(ByteBuf byteBuf, int metadataOffset) {
        int flags = FrameHeaderFlyweight.flags(byteBuf);
        if (256 == (0x100 & flags)) {
            return FrameHeaderFlyweight.decodeLength(byteBuf, metadataOffset);
        }
        return null;
    }

    private static int computeMetadataLength(FrameType frameType, @Nullable Integer length) {
        if (!FrameHeaderFlyweight.hasMetadataLengthField(frameType)) {
            return length != null ? length : 0;
        }
        return length == null ? 0 : length + 3;
    }

    public static boolean hasMetadataLengthField(FrameType frameType) {
        return frameType.canHaveData();
    }

    public static void encodeLength(ByteBuf byteBuf, int offset, int length) {
        if ((length & 0xFF000000) != 0) {
            throw new IllegalArgumentException("Length is larger than 24 bits");
        }
        byteBuf.setByte(offset, length >> 16);
        byteBuf.setByte(offset + 1, length >> 8);
        byteBuf.setByte(offset + 2, length);
    }

    private static int decodeLength(ByteBuf byteBuf, int offset) {
        int length = (byteBuf.getByte(offset) & 0xFF) << 16;
        length |= (byteBuf.getByte(offset + 1) & 0xFF) << 8;
        return length |= byteBuf.getByte(offset + 2) & 0xFF;
    }

    public static int dataLength(ByteBuf byteBuf, FrameType frameType) {
        return FrameHeaderFlyweight.dataLength(byteBuf, frameType, FrameHeaderFlyweight.payloadOffset(byteBuf));
    }

    static int dataLength(ByteBuf byteBuf, FrameType frameType, int payloadOffset) {
        int frameLength = FrameHeaderFlyweight.frameLength(byteBuf);
        int metadataLength = FrameHeaderFlyweight.metadataFieldLength(byteBuf, frameType, frameLength);
        return frameLength - metadataLength - payloadOffset;
    }

    public static int payloadLength(ByteBuf byteBuf) {
        int frameLength = FrameHeaderFlyweight.frameLength(byteBuf);
        int payloadOffset = FrameHeaderFlyweight.payloadOffset(byteBuf);
        return frameLength - payloadOffset;
    }

    private static int payloadOffset(ByteBuf byteBuf) {
        short typeAndFlags = byteBuf.getShort(FRAME_TYPE_AND_FLAGS_FIELD_OFFSET);
        FrameType frameType = FrameType.fromEncodedType(typeAndFlags >> 10);
        int result = PAYLOAD_OFFSET;
        switch (frameType) {
            case SETUP: {
                result = SetupFrameFlyweight.payloadOffset(byteBuf);
                break;
            }
            case ERROR: {
                result = ErrorFrameFlyweight.payloadOffset(byteBuf);
                break;
            }
            case LEASE: {
                result = LeaseFrameFlyweight.payloadOffset(byteBuf);
                break;
            }
            case KEEPALIVE: {
                result = KeepaliveFrameFlyweight.payloadOffset(byteBuf);
                break;
            }
            case REQUEST_RESPONSE: 
            case REQUEST_FNF: 
            case REQUEST_STREAM: 
            case REQUEST_CHANNEL: {
                result = RequestFrameFlyweight.payloadOffset(frameType, byteBuf);
                break;
            }
            case REQUEST_N: {
                result = RequestNFrameFlyweight.payloadOffset(byteBuf);
            }
        }
        return result;
    }

    public static int metadataOffset(ByteBuf byteBuf) {
        return FrameHeaderFlyweight.payloadOffset(byteBuf);
    }

    public static int dataOffset(ByteBuf byteBuf, FrameType frameType, int frameLength) {
        return FrameHeaderFlyweight.payloadOffset(byteBuf) + FrameHeaderFlyweight.metadataFieldLength(byteBuf, frameType, frameLength);
    }

    static {
        FRAME_LENGTH_FIELD_OFFSET = 0;
        STREAM_ID_FIELD_OFFSET = FRAME_LENGTH_FIELD_OFFSET + 3;
        FRAME_TYPE_AND_FLAGS_FIELD_OFFSET = STREAM_ID_FIELD_OFFSET + 4;
        FRAME_HEADER_LENGTH = PAYLOAD_OFFSET = FRAME_TYPE_AND_FLAGS_FIELD_OFFSET + 2;
    }
}

