/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.rsocket.DuplexConnection;
import io.rsocket.Frame;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.exceptions.ApplicationErrorException;
import io.rsocket.framing.FrameType;
import io.rsocket.internal.LimitableRequestPublisher;
import io.rsocket.internal.UnboundedProcessor;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jctools.maps.NonBlockingHashMapLong;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.core.publisher.UnicastProcessor;

class RSocketServer
implements RSocket {
    private final DuplexConnection connection;
    private final RSocket requestHandler;
    private final Function<Frame, ? extends Payload> frameDecoder;
    private final Consumer<Throwable> errorConsumer;
    private final NonBlockingHashMapLong<Subscription> sendingSubscriptions;
    private final NonBlockingHashMapLong<UnicastProcessor<Payload>> channelProcessors;
    private final UnboundedProcessor<Frame> sendProcessor;
    private Disposable receiveDisposable;

    RSocketServer(DuplexConnection connection, RSocket requestHandler, Function<Frame, ? extends Payload> frameDecoder, Consumer<Throwable> errorConsumer) {
        this.connection = connection;
        this.requestHandler = requestHandler;
        this.frameDecoder = frameDecoder;
        this.errorConsumer = errorConsumer;
        this.sendingSubscriptions = new NonBlockingHashMapLong();
        this.channelProcessors = new NonBlockingHashMapLong();
        this.sendProcessor = new UnboundedProcessor();
        connection.send(this.sendProcessor).doFinally(this::handleSendProcessorCancel).subscribe(null, this::handleSendProcessorError);
        this.receiveDisposable = connection.receive().subscribe(this::handleFrame, errorConsumer);
        this.connection.onClose().doFinally(s -> {
            this.cleanup();
            this.receiveDisposable.dispose();
        }).subscribe(null, errorConsumer);
    }

    private void handleSendProcessorError(Throwable t) {
        for (Subscription subscription : this.sendingSubscriptions.values()) {
            try {
                subscription.cancel();
            }
            catch (Throwable e) {
                this.errorConsumer.accept(e);
            }
        }
        for (UnicastProcessor unicastProcessor : this.channelProcessors.values()) {
            try {
                unicastProcessor.cancel();
            }
            catch (Throwable e) {
                this.errorConsumer.accept(e);
            }
        }
    }

    private void handleSendProcessorCancel(SignalType t) {
        if (SignalType.ON_ERROR == t) {
            return;
        }
        for (Subscription subscription : this.sendingSubscriptions.values()) {
            try {
                subscription.cancel();
            }
            catch (Throwable e) {
                this.errorConsumer.accept(e);
            }
        }
        for (UnicastProcessor unicastProcessor : this.channelProcessors.values()) {
            try {
                unicastProcessor.cancel();
            }
            catch (Throwable e) {
                this.errorConsumer.accept(e);
            }
        }
    }

    @Override
    public Mono<Void> fireAndForget(Payload payload) {
        try {
            return this.requestHandler.fireAndForget(payload);
        }
        catch (Throwable t) {
            return Mono.error(t);
        }
    }

    @Override
    public Mono<Payload> requestResponse(Payload payload) {
        try {
            return this.requestHandler.requestResponse(payload);
        }
        catch (Throwable t) {
            return Mono.error(t);
        }
    }

    @Override
    public Flux<Payload> requestStream(Payload payload) {
        try {
            return this.requestHandler.requestStream(payload);
        }
        catch (Throwable t) {
            return Flux.error(t);
        }
    }

    @Override
    public Flux<Payload> requestChannel(Publisher<Payload> payloads) {
        try {
            return this.requestHandler.requestChannel(payloads);
        }
        catch (Throwable t) {
            return Flux.error(t);
        }
    }

    @Override
    public Mono<Void> metadataPush(Payload payload) {
        try {
            return this.requestHandler.metadataPush(payload);
        }
        catch (Throwable t) {
            return Mono.error(t);
        }
    }

    @Override
    public void dispose() {
        this.connection.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.connection.isDisposed();
    }

    @Override
    public Mono<Void> onClose() {
        return this.connection.onClose();
    }

    private void cleanup() {
        this.cleanUpSendingSubscriptions();
        this.cleanUpChannelProcessors();
        this.requestHandler.dispose();
    }

    private synchronized void cleanUpSendingSubscriptions() {
        this.sendingSubscriptions.values().forEach(Subscription::cancel);
        this.sendingSubscriptions.clear();
    }

    private synchronized void cleanUpChannelProcessors() {
        this.channelProcessors.values().forEach(Subscription::cancel);
        this.channelProcessors.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleFrame(Frame frame) {
        try {
            int streamId = frame.getStreamId();
            switch (frame.getType()) {
                case REQUEST_FNF: {
                    this.handleFireAndForget(streamId, this.fireAndForget(this.frameDecoder.apply(frame)));
                    return;
                }
                case REQUEST_RESPONSE: {
                    this.handleRequestResponse(streamId, this.requestResponse(this.frameDecoder.apply(frame)));
                    return;
                }
                case CANCEL: {
                    this.handleCancelFrame(streamId);
                    return;
                }
                case KEEPALIVE: {
                    this.handleKeepAliveFrame(frame);
                    return;
                }
                case REQUEST_N: {
                    this.handleRequestN(streamId, frame);
                    return;
                }
                case REQUEST_STREAM: {
                    this.handleStream(streamId, this.requestStream(this.frameDecoder.apply(frame)), Frame.Request.initialRequestN(frame));
                    return;
                }
                case REQUEST_CHANNEL: {
                    this.handleChannel(streamId, frame);
                    return;
                }
                case PAYLOAD: {
                    return;
                }
                case METADATA_PUSH: {
                    this.metadataPush(this.frameDecoder.apply(frame));
                    return;
                }
                case LEASE: {
                    return;
                }
                case NEXT: {
                    Subscriber receiver = this.channelProcessors.get(streamId);
                    if (receiver == null) return;
                    receiver.onNext(this.frameDecoder.apply(frame));
                    return;
                }
                case COMPLETE: {
                    Subscriber receiver = this.channelProcessors.get(streamId);
                    if (receiver == null) return;
                    receiver.onComplete();
                    return;
                }
                case ERROR: {
                    Subscriber receiver = this.channelProcessors.get(streamId);
                    if (receiver == null) return;
                    receiver.onError(new ApplicationErrorException(Frame.Error.message(frame)));
                    return;
                }
                case NEXT_COMPLETE: {
                    Subscriber receiver = this.channelProcessors.get(streamId);
                    if (receiver == null) return;
                    receiver.onNext(this.frameDecoder.apply(frame));
                    receiver.onComplete();
                    return;
                }
                case SETUP: {
                    this.handleError(streamId, new IllegalStateException("Setup frame received post setup."));
                    return;
                }
                default: {
                    this.handleError(streamId, new IllegalStateException("ServerRSocket: Unexpected frame type: " + (Object)((Object)frame.getType())));
                    return;
                }
            }
        }
        finally {
            frame.release();
        }
    }

    private void handleFireAndForget(int streamId, Mono<Void> result) {
        result.doFinally(signalType -> this.sendingSubscriptions.remove(streamId)).subscribe(null, this.errorConsumer, null, subscription -> this.sendingSubscriptions.put(streamId, (Subscription)subscription));
    }

    private void handleRequestResponse(int streamId, Mono<Payload> response) {
        response.doOnSubscribe(subscription -> this.sendingSubscriptions.put(streamId, (Subscription)subscription)).map(payload -> {
            int flags = 64;
            if (payload.hasMetadata()) {
                flags = Frame.setFlag(flags, 256);
            }
            Frame frame = Frame.PayloadFrame.from(streamId, FrameType.NEXT_COMPLETE, payload, flags);
            payload.release();
            return frame;
        }).switchIfEmpty(Mono.fromCallable(() -> Frame.PayloadFrame.from(streamId, FrameType.COMPLETE))).doFinally(signalType -> this.sendingSubscriptions.remove(streamId)).subscribe(this.sendProcessor::onNext, t -> this.handleError(streamId, (Throwable)t));
    }

    private void handleStream(int streamId, Flux<Payload> response, int initialRequestN) {
        response.map(payload -> {
            Frame frame = Frame.PayloadFrame.from(streamId, FrameType.NEXT, payload);
            payload.release();
            return frame;
        }).concatWith(Mono.fromCallable(() -> Frame.PayloadFrame.from(streamId, FrameType.COMPLETE))).transform(frameFlux -> {
            LimitableRequestPublisher frames = LimitableRequestPublisher.wrap(frameFlux);
            this.sendingSubscriptions.put(streamId, (Subscription)frames);
            frames.increaseRequestLimit(initialRequestN);
            return frames;
        }).doFinally(signalType -> this.sendingSubscriptions.remove(streamId)).subscribe(this.sendProcessor::onNext, t -> this.handleError(streamId, (Throwable)t));
    }

    private void handleChannel(int streamId, Frame firstFrame) {
        UnicastProcessor frames = UnicastProcessor.create();
        this.channelProcessors.put(streamId, (UnicastProcessor<Payload>)frames);
        Flux<Payload> payloads = frames.doOnCancel(() -> this.sendProcessor.onNext(Frame.Cancel.from(streamId))).doOnError(t -> this.sendProcessor.onNext(Frame.Error.from(streamId, t))).doOnRequest(l -> this.sendProcessor.onNext(Frame.RequestN.from(streamId, l))).doFinally(signalType -> this.channelProcessors.remove(streamId));
        frames.onNext(this.frameDecoder.apply(firstFrame));
        this.handleStream(streamId, this.requestChannel(payloads), Frame.Request.initialRequestN(firstFrame));
    }

    private void handleKeepAliveFrame(Frame frame) {
        if (Frame.Keepalive.hasRespondFlag(frame)) {
            ByteBuf data = Unpooled.wrappedBuffer(frame.getData());
            this.sendProcessor.onNext(Frame.Keepalive.from(data, false));
        }
    }

    private void handleCancelFrame(int streamId) {
        Subscription subscription = this.sendingSubscriptions.remove(streamId);
        if (subscription != null) {
            subscription.cancel();
        }
    }

    private void handleError(int streamId, Throwable t) {
        this.errorConsumer.accept(t);
        this.sendProcessor.onNext(Frame.Error.from(streamId, t));
    }

    private void handleRequestN(int streamId, Frame frame) {
        Subscription subscription = this.sendingSubscriptions.get(streamId);
        if (subscription != null) {
            int n = Frame.RequestN.requestN(frame);
            subscription.request(n >= Integer.MAX_VALUE ? Long.MAX_VALUE : (long)n);
        }
    }
}

