/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.security.vault;

import com.bettercloud.vault.json.Json;
import com.bettercloud.vault.rest.Rest;
import com.bettercloud.vault.rest.RestException;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaultServiceRolesInstaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(VaultServiceRolesInstaller.class);
    private static final String VAULT_TOKEN_HEADER = "X-Vault-Token";
    private static final List<Supplier<ServiceRoles>> DEFAULT_SERVICE_ROLES_SOURCES = Collections.singletonList(new ResourcesServiceRolesSupplier());
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory()).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    private final String vaultAddress;
    private final Supplier<CompletableFuture<String>> vaultTokenSupplier;
    private final Supplier<String> keyNameSupplier;
    private final Function<String, String> roleNameBuilder;
    private final List<Supplier<ServiceRoles>> serviceRolesSources;
    private final String keyAlgorithm;
    private final String keyRotationPeriod;
    private final String keyVerificationTtl;
    private final String roleTtl;
    private final long timeout;
    private final TimeUnit timeUnit;

    private VaultServiceRolesInstaller(Builder builder) {
        this.vaultAddress = builder.vaultAddress;
        this.vaultTokenSupplier = builder.vaultTokenSupplier;
        this.keyNameSupplier = builder.keyNameSupplier;
        this.roleNameBuilder = builder.roleNameBuilder;
        this.serviceRolesSources = builder.serviceRolesSources;
        this.keyAlgorithm = builder.keyAlgorithm;
        this.keyRotationPeriod = builder.keyRotationPeriod;
        this.keyVerificationTtl = builder.keyVerificationTtl;
        this.roleTtl = builder.roleTtl;
        this.timeout = builder.timeout;
        this.timeUnit = builder.timeUnit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void install() {
        if (VaultServiceRolesInstaller.isNullOrNoneOrEmpty(this.vaultAddress)) {
            LOGGER.debug("Skipping serviceRoles installation, vaultAddress not set");
            return;
        }
        ServiceRoles serviceRoles = this.loadServiceRoles();
        if (serviceRoles == null || serviceRoles.roles.isEmpty()) {
            LOGGER.debug("Skipping serviceRoles installation, serviceRoles not set");
            return;
        }
        try {
            ((CompletableFuture)this.vaultTokenSupplier.get().thenAcceptAsync(token -> {
                Rest rest = new Rest().header(VAULT_TOKEN_HEADER, token);
                String keyName = this.keyNameSupplier.get();
                this.createVaultIdentityKey(rest.url(this.vaultIdentityKeyUri(keyName)), keyName);
                for (ServiceRoles.Role role : serviceRoles.roles) {
                    String roleName = this.roleNameBuilder.apply(role.role);
                    this.createVaultIdentityRole(rest.url(this.vaultIdentityRoleUri(roleName)), keyName, role.role, role.permissions);
                }
                LOGGER.debug("Installed serviceRoles ({})", (Object)serviceRoles);
            })).get(this.timeout, this.timeUnit);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ServiceRoles loadServiceRoles() {
        if (this.serviceRolesSources == null) {
            return null;
        }
        for (Supplier<ServiceRoles> serviceRolesSource : this.serviceRolesSources) {
            ServiceRoles serviceRoles = serviceRolesSource.get();
            if (serviceRoles == null) continue;
            return serviceRoles;
        }
        return null;
    }

    private static void awaitSuccess(int status) {
        if (status != 200 && status != 204) {
            throw new IllegalStateException("Not expected status returned, status=" + status);
        }
    }

    private void createVaultIdentityKey(Rest rest, String keyName) {
        byte[] body = Json.object().add("rotation_period", this.keyRotationPeriod).add("verification_ttl", this.keyVerificationTtl).add("allowed_client_ids", "*").add("algorithm", this.keyAlgorithm).toString().getBytes();
        try {
            VaultServiceRolesInstaller.awaitSuccess(rest.body(body).post().getStatus());
            LOGGER.debug("Created vault identity key: {}", (Object)keyName);
        }
        catch (RestException e) {
            throw new RuntimeException("Failed to create vault identity key: " + keyName, e);
        }
    }

    private void createVaultIdentityRole(Rest rest, String keyName, String roleName, List<String> permissions) {
        byte[] body = Json.object().add("key", keyName).add("template", VaultServiceRolesInstaller.createTemplate(roleName, permissions)).add("ttl", this.roleTtl).toString().getBytes();
        try {
            VaultServiceRolesInstaller.awaitSuccess(rest.body(body).post().getStatus());
            LOGGER.debug("Created vault identity role: {}", (Object)roleName);
        }
        catch (RestException e) {
            throw new RuntimeException("Failed to create vault identity role: " + roleName, e);
        }
    }

    private static String createTemplate(String roleName, List<String> permissions) {
        return Base64.getUrlEncoder().encodeToString(Json.object().add("role", roleName).add("permissions", String.join((CharSequence)",", permissions)).toString().getBytes());
    }

    private String vaultIdentityKeyUri(String keyName) {
        return new StringJoiner("/", this.vaultAddress, "").add("/v1/identity/oidc/key").add(keyName).toString();
    }

    private String vaultIdentityRoleUri(String roleName) {
        return new StringJoiner("/", this.vaultAddress, "").add("/v1/identity/oidc/role").add(roleName).toString();
    }

    private static boolean isNullOrNoneOrEmpty(String value) {
        return Objects.isNull(value) || "none".equalsIgnoreCase(value) || "null".equals(value) || value.isEmpty();
    }

    public static class Builder {
        private String vaultAddress;
        private Supplier<CompletableFuture<String>> vaultTokenSupplier;
        private Supplier<String> keyNameSupplier;
        private Function<String, String> roleNameBuilder;
        private List<Supplier<ServiceRoles>> serviceRolesSources = DEFAULT_SERVICE_ROLES_SOURCES;
        private String keyAlgorithm = "RS256";
        private String keyRotationPeriod = "1h";
        private String keyVerificationTtl = "1h";
        private String roleTtl = "1m";
        private long timeout = 10L;
        private TimeUnit timeUnit = TimeUnit.SECONDS;

        private Builder() {
        }

        public Builder vaultAddress(String vaultAddress) {
            this.vaultAddress = vaultAddress;
            return this;
        }

        public Builder vaultTokenSupplier(Supplier<CompletableFuture<String>> vaultTokenSupplier) {
            this.vaultTokenSupplier = vaultTokenSupplier;
            return this;
        }

        public Builder keyNameSupplier(Supplier<String> keyNameSupplier) {
            this.keyNameSupplier = keyNameSupplier;
            return this;
        }

        public Builder roleNameBuilder(Function<String, String> roleNameBuilder) {
            this.roleNameBuilder = roleNameBuilder;
            return this;
        }

        public Builder serviceRolesSources(List<Supplier<ServiceRoles>> serviceRolesSources) {
            this.serviceRolesSources = serviceRolesSources;
            return this;
        }

        public Builder keyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            return this;
        }

        public Builder keyRotationPeriod(String keyRotationPeriod) {
            this.keyRotationPeriod = keyRotationPeriod;
            return this;
        }

        public Builder keyVerificationTtl(String keyVerificationTtl) {
            this.keyVerificationTtl = keyVerificationTtl;
            return this;
        }

        public Builder roleTtl(String roleTtl) {
            this.roleTtl = roleTtl;
            return this;
        }

        public Builder timeout(long timeout, TimeUnit timeUnit) {
            this.timeout = timeout;
            this.timeUnit = timeUnit;
            return this;
        }

        public VaultServiceRolesInstaller build() {
            return new VaultServiceRolesInstaller(this);
        }
    }

    public static class ServiceRoles {
        private List<Role> roles;

        public List<Role> roles() {
            return this.roles;
        }

        public ServiceRoles roles(List<Role> roles) {
            this.roles = roles;
            return this;
        }

        public String toString() {
            return new StringJoiner(", ", ServiceRoles.class.getSimpleName() + "[", "]").add("roles=" + String.valueOf(this.roles)).toString();
        }

        public static class Role {
            private String role;
            private List<String> permissions;

            public String role() {
                return this.role;
            }

            public Role role(String role) {
                this.role = role;
                return this;
            }

            public List<String> permissions() {
                return this.permissions;
            }

            public Role permissions(List<String> permissions) {
                this.permissions = permissions;
                return this;
            }

            public String toString() {
                return new StringJoiner(", ", Role.class.getSimpleName() + "[", "]").add("role='" + this.role + "'").add("permissions=" + String.valueOf(this.permissions)).toString();
            }
        }
    }

    public static class ResourcesServiceRolesSupplier
    implements Supplier<ServiceRoles> {
        public static final String DEFAULT_FILE_NAME = "service-roles.yaml";
        private final String fileName;

        public ResourcesServiceRolesSupplier() {
            this(DEFAULT_FILE_NAME);
        }

        public ResourcesServiceRolesSupplier(String fileName) {
            this.fileName = Objects.requireNonNull(fileName, "fileName");
        }

        @Override
        public ServiceRoles get() {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                InputStream inputStream = classLoader.getResourceAsStream(this.fileName);
                return inputStream != null ? (ServiceRoles)OBJECT_MAPPER.readValue(inputStream, ServiceRoles.class) : null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return new StringJoiner(", ", ResourcesServiceRolesSupplier.class.getSimpleName() + "[", "]").add("fileName='" + this.fileName + "'").toString();
        }
    }

    public static class FileServiceRolesSupplier
    implements Supplier<ServiceRoles> {
        public static final String DEFAULT_FILE = "service-roles.yaml";
        private final String file;

        public FileServiceRolesSupplier() {
            this(DEFAULT_FILE);
        }

        public FileServiceRolesSupplier(String file) {
            this.file = Objects.requireNonNull(file, "file");
        }

        @Override
        public ServiceRoles get() {
            ServiceRoles serviceRoles;
            File file = new File(this.file);
            if (!file.exists()) {
                return null;
            }
            FileInputStream fis = new FileInputStream(file);
            try {
                serviceRoles = (ServiceRoles)OBJECT_MAPPER.readValue((InputStream)fis, ServiceRoles.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            fis.close();
            return serviceRoles;
        }

        public String toString() {
            return new StringJoiner(", ", FileServiceRolesSupplier.class.getSimpleName() + "[", "]").add("file='" + this.file + "'").toString();
        }
    }

    public static class EnvironmentServiceRolesSupplier
    implements Supplier<ServiceRoles> {
        public static final String DEFAULT_ENV_KEY = "SERVICE_ROLES";
        private final String envKey;

        public EnvironmentServiceRolesSupplier() {
            this(DEFAULT_ENV_KEY);
        }

        public EnvironmentServiceRolesSupplier(String envKey) {
            this.envKey = Objects.requireNonNull(envKey, "envKey");
        }

        @Override
        public ServiceRoles get() {
            try {
                String value = System.getenv(this.envKey);
                return value != null ? (ServiceRoles)OBJECT_MAPPER.readValue((Reader)new StringReader(value), ServiceRoles.class) : null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return new StringJoiner(", ", EnvironmentServiceRolesSupplier.class.getSimpleName() + "[", "]").add("envKey='" + this.envKey + "'").toString();
        }
    }
}

