/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.security.vault;

import com.bettercloud.vault.json.Json;
import com.bettercloud.vault.rest.Rest;
import com.bettercloud.vault.rest.RestException;
import com.bettercloud.vault.rest.RestResponse;
import io.scalecube.utils.MaskUtil;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public final class VaultServiceTokenSupplier {
    private static final Logger LOGGER = LoggerFactory.getLogger(VaultServiceTokenSupplier.class);
    private static final String VAULT_TOKEN_HEADER = "X-Vault-Token";
    private String serviceRole;
    private String vaultAddress;
    private Mono<String> vaultTokenSupplier;
    private BiFunction<String, Map<String, String>, String> serviceTokenNameBuilder;

    public VaultServiceTokenSupplier() {
    }

    private VaultServiceTokenSupplier(VaultServiceTokenSupplier other) {
        this.serviceRole = other.serviceRole;
        this.vaultAddress = other.vaultAddress;
        this.vaultTokenSupplier = other.vaultTokenSupplier;
        this.serviceTokenNameBuilder = other.serviceTokenNameBuilder;
    }

    private VaultServiceTokenSupplier copy() {
        return new VaultServiceTokenSupplier(this);
    }

    private void validate() {
        Objects.requireNonNull(this.serviceRole, "VaultServiceTokenSupplier.serviceRole");
        Objects.requireNonNull(this.vaultAddress, "VaultServiceTokenSupplier.vaultAddress");
        Objects.requireNonNull(this.vaultTokenSupplier, "VaultServiceTokenSupplier.vaultTokenSupplier");
        Objects.requireNonNull(this.serviceTokenNameBuilder, "VaultServiceTokenSupplier.serviceTokenNameBuilder");
    }

    public VaultServiceTokenSupplier serviceRole(String serviceRole) {
        VaultServiceTokenSupplier c = this.copy();
        c.serviceRole = serviceRole;
        return c;
    }

    public VaultServiceTokenSupplier vaultAddress(String vaultAddress) {
        VaultServiceTokenSupplier c = this.copy();
        c.vaultAddress = vaultAddress;
        return c;
    }

    public VaultServiceTokenSupplier vaultTokenSupplier(Mono<String> vaultTokenSupplier) {
        VaultServiceTokenSupplier c = this.copy();
        c.vaultTokenSupplier = vaultTokenSupplier;
        return c;
    }

    public VaultServiceTokenSupplier serviceTokenNameBuilder(BiFunction<String, Map<String, String>, String> serviceTokenNameBuilder) {
        VaultServiceTokenSupplier c = this.copy();
        c.serviceTokenNameBuilder = serviceTokenNameBuilder;
        return c;
    }

    public Mono<String> getToken(Map<String, String> tags) {
        return Mono.fromRunnable(this::validate).then(Mono.defer(() -> this.vaultTokenSupplier)).subscribeOn(Schedulers.boundedElastic()).flatMap(vaultToken -> {
            String uri = this.buildServiceTokenUri(tags);
            return Mono.fromCallable(() -> VaultServiceTokenSupplier.rpcGetToken(uri, vaultToken)).doOnSuccess(s -> LOGGER.debug("[getToken][success] uri='{}', tags={}, result: {}", new Object[]{uri, tags, MaskUtil.mask((String)s)})).doOnError(th -> LOGGER.error("[getToken][error] uri='{}', tags={}, cause: {}", new Object[]{uri, tags, th.toString()}));
        });
    }

    private static String rpcGetToken(String uri, String vaultToken) {
        try {
            RestResponse response = new Rest().header(VAULT_TOKEN_HEADER, vaultToken).url(uri).get();
            VaultServiceTokenSupplier.verifyOk(response.getStatus());
            return Json.parse((String)new String(response.getBody())).asObject().get("data").asObject().get("token").asString();
        }
        catch (RestException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private static void verifyOk(int status) {
        if (status != 200) {
            LOGGER.error("[rpcGetToken] Not expected status ({}) returned", (Object)status);
            throw new IllegalStateException("Not expected status returned, status=" + status);
        }
    }

    private String buildServiceTokenUri(Map<String, String> tags) {
        return new StringJoiner("/", this.vaultAddress, "").add("/v1/identity/oidc/token").add(this.serviceTokenNameBuilder.apply(this.serviceRole, tags)).toString();
    }
}

