/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.security.vault;

import com.bettercloud.vault.json.Json;
import com.bettercloud.vault.rest.Rest;
import com.bettercloud.vault.rest.RestException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public final class VaultServiceRolesInstaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(VaultServiceRolesInstaller.class);
    private static final String VAULT_TOKEN_HEADER = "X-Vault-Token";
    private static final List<Supplier<ServiceRoles>> DEFAULT_SERVICE_ROLES_SOURCES = Collections.singletonList(new ResourcesServiceRolesSupplier());
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private String vaultAddress;
    private Mono<String> vaultTokenSupplier;
    private Supplier<String> keyNameSupplier;
    private Function<String, String> roleNameBuilder;
    private List<Supplier<ServiceRoles>> serviceRolesSources = DEFAULT_SERVICE_ROLES_SOURCES;
    private String keyAlgorithm = "RS256";
    private String keyRotationPeriod = "1h";
    private String keyVerificationTtl = "1h";
    private String roleTtl = "1m";

    public VaultServiceRolesInstaller() {
    }

    private VaultServiceRolesInstaller(VaultServiceRolesInstaller other) {
        this.vaultAddress = other.vaultAddress;
        this.vaultTokenSupplier = other.vaultTokenSupplier;
        this.keyNameSupplier = other.keyNameSupplier;
        this.roleNameBuilder = other.roleNameBuilder;
        this.serviceRolesSources = other.serviceRolesSources;
        this.keyAlgorithm = other.keyAlgorithm;
        this.keyRotationPeriod = other.keyRotationPeriod;
        this.keyVerificationTtl = other.keyVerificationTtl;
        this.roleTtl = other.roleTtl;
    }

    private VaultServiceRolesInstaller copy() {
        return new VaultServiceRolesInstaller(this);
    }

    public VaultServiceRolesInstaller vaultAddress(String vaultAddress) {
        VaultServiceRolesInstaller c = this.copy();
        c.vaultAddress = vaultAddress;
        return c;
    }

    public VaultServiceRolesInstaller vaultTokenSupplier(Mono<String> vaultTokenSupplier) {
        VaultServiceRolesInstaller c = this.copy();
        c.vaultTokenSupplier = vaultTokenSupplier;
        return c;
    }

    public VaultServiceRolesInstaller keyNameSupplier(Supplier<String> keyNameSupplier) {
        VaultServiceRolesInstaller c = this.copy();
        c.keyNameSupplier = keyNameSupplier;
        return c;
    }

    public VaultServiceRolesInstaller roleNameBuilder(Function<String, String> roleNameBuilder) {
        VaultServiceRolesInstaller c = this.copy();
        c.roleNameBuilder = roleNameBuilder;
        return c;
    }

    public VaultServiceRolesInstaller serviceRolesSources(List<Supplier<ServiceRoles>> serviceRolesSources) {
        VaultServiceRolesInstaller c = this.copy();
        c.serviceRolesSources = serviceRolesSources;
        return c;
    }

    public VaultServiceRolesInstaller serviceRolesSources(Supplier<ServiceRoles> ... serviceRolesSources) {
        VaultServiceRolesInstaller c = this.copy();
        c.serviceRolesSources = Arrays.asList(serviceRolesSources);
        return c;
    }

    public VaultServiceRolesInstaller keyAlgorithm(String keyAlgorithm) {
        VaultServiceRolesInstaller c = this.copy();
        c.keyAlgorithm = keyAlgorithm;
        return c;
    }

    public VaultServiceRolesInstaller keyRotationPeriod(String keyRotationPeriod) {
        VaultServiceRolesInstaller c = this.copy();
        c.keyRotationPeriod = keyRotationPeriod;
        return c;
    }

    public VaultServiceRolesInstaller keyVerificationTtl(String keyVerificationTtl) {
        VaultServiceRolesInstaller c = this.copy();
        c.keyVerificationTtl = keyVerificationTtl;
        return c;
    }

    public VaultServiceRolesInstaller roleTtl(String roleTtl) {
        VaultServiceRolesInstaller c = this.copy();
        c.roleTtl = roleTtl;
        return c;
    }

    public Mono<Void> install() {
        return Mono.defer(this::install0).subscribeOn(Schedulers.boundedElastic()).doOnError(th -> LOGGER.error("Failed to install serviceRoles, cause: {}", (Object)th.toString()));
    }

    private Mono<Void> install0() {
        if (VaultServiceRolesInstaller.isNullOrNoneOrEmpty(this.vaultAddress)) {
            LOGGER.debug("Skipping serviceRoles installation, vaultAddress not set");
            return Mono.empty();
        }
        ServiceRoles serviceRoles = this.loadServiceRoles();
        if (serviceRoles == null || serviceRoles.roles.isEmpty()) {
            LOGGER.debug("Skipping serviceRoles installation, serviceRoles not set");
            return Mono.empty();
        }
        return Mono.defer(() -> this.vaultTokenSupplier).doOnSuccess(token -> {
            Rest rest = new Rest().header(VAULT_TOKEN_HEADER, token);
            String keyName = this.keyNameSupplier.get();
            this.createVaultIdentityKey(rest.url(this.buildVaultIdentityKeyUri(keyName)), keyName);
            for (ServiceRoles.Role role : serviceRoles.roles) {
                String roleName = this.roleNameBuilder.apply(role.role);
                this.createVaultIdentityRole(rest.url(this.buildVaultIdentityRoleUri(roleName)), keyName, roleName, role.permissions);
            }
        }).doOnSuccess(s -> LOGGER.debug("Installed serviceRoles ({})", (Object)serviceRoles)).then();
    }

    private ServiceRoles loadServiceRoles() {
        if (this.serviceRolesSources == null) {
            return null;
        }
        for (Supplier<ServiceRoles> serviceRolesSource : this.serviceRolesSources) {
            try {
                ServiceRoles serviceRoles = serviceRolesSource.get();
                if (serviceRoles == null) continue;
                return serviceRoles;
            }
            catch (Throwable th) {
                LOGGER.warn("Failed to load serviceRoles from {}, cause {}", serviceRolesSource, (Object)th.getMessage());
            }
        }
        return null;
    }

    private static void verifyOk(int status, String operation) {
        if (status != 200 && status != 204) {
            LOGGER.error("Not expected status ({}) returned on [{}]", (Object)status, (Object)operation);
            throw new IllegalStateException("Not expected status returned, status=" + status);
        }
    }

    private void createVaultIdentityKey(Rest rest, String keyName) {
        LOGGER.debug("[createVaultIdentityKey] {}", (Object)keyName);
        byte[] body = Json.object().add("rotation_period", this.keyRotationPeriod).add("verification_ttl", this.keyVerificationTtl).add("allowed_client_ids", "*").add("algorithm", this.keyAlgorithm).toString().getBytes();
        try {
            VaultServiceRolesInstaller.verifyOk(rest.body(body).post().getStatus(), "createVaultIdentityKey");
        }
        catch (RestException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private void createVaultIdentityRole(Rest rest, String keyName, String roleName, List<String> permissions) {
        LOGGER.debug("[createVaultIdentityRole] {}", (Object)roleName);
        byte[] body = Json.object().add("key", keyName).add("template", VaultServiceRolesInstaller.createTemplate(permissions)).add("ttl", this.roleTtl).toString().getBytes();
        try {
            VaultServiceRolesInstaller.verifyOk(rest.body(body).post().getStatus(), "createVaultIdentityRole");
        }
        catch (RestException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private static String createTemplate(List<String> permissions) {
        return Base64.getUrlEncoder().encodeToString(Json.object().add("permissions", String.join((CharSequence)",", permissions)).toString().getBytes());
    }

    private String buildVaultIdentityKeyUri(String keyName) {
        return new StringJoiner("/", this.vaultAddress, "").add("/v1/identity/oidc/key").add(keyName).toString();
    }

    private String buildVaultIdentityRoleUri(String roleName) {
        return new StringJoiner("/", this.vaultAddress, "").add("/v1/identity/oidc/role").add(roleName).toString();
    }

    private static boolean isNullOrNoneOrEmpty(String value) {
        return Objects.isNull(value) || "none".equalsIgnoreCase(value) || "null".equals(value) || value.isEmpty();
    }

    public static class FileServiceRolesSupplier
    implements Supplier<ServiceRoles> {
        public static final String DEFAULT_FILE = "service_roles.yaml";
        private final String file;

        public FileServiceRolesSupplier() {
            this(DEFAULT_FILE);
        }

        public FileServiceRolesSupplier(String file) {
            this.file = Objects.requireNonNull(file, "file");
        }

        @Override
        public ServiceRoles get() {
            try {
                File file = new File(this.file);
                return file.exists() ? (ServiceRoles)OBJECT_MAPPER.readValue((InputStream)new FileInputStream(file), ServiceRoles.class) : null;
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }

        public String toString() {
            return new StringJoiner(", ", FileServiceRolesSupplier.class.getSimpleName() + "[", "]").add("file='" + this.file + "'").toString();
        }
    }

    public static class EnvironmentServiceRolesSupplier
    implements Supplier<ServiceRoles> {
        public static final String DEFAULT_ENV_KEY = "SERVICE_ROLES";
        private final String envKey;

        public EnvironmentServiceRolesSupplier() {
            this(DEFAULT_ENV_KEY);
        }

        public EnvironmentServiceRolesSupplier(String envKey) {
            this.envKey = Objects.requireNonNull(envKey, "envKey");
        }

        @Override
        public ServiceRoles get() {
            try {
                String value = System.getenv(this.envKey);
                return value != null ? (ServiceRoles)OBJECT_MAPPER.readValue((Reader)new StringReader(value), ServiceRoles.class) : null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return new StringJoiner(", ", EnvironmentServiceRolesSupplier.class.getSimpleName() + "[", "]").add("envKey='" + this.envKey + "'").toString();
        }
    }

    public static class ResourcesServiceRolesSupplier
    implements Supplier<ServiceRoles> {
        public static final String DEFAULT_FILE_NAME = "service-roles.yaml";
        private final String fileName;

        public ResourcesServiceRolesSupplier() {
            this(DEFAULT_FILE_NAME);
        }

        public ResourcesServiceRolesSupplier(String fileName) {
            this.fileName = Objects.requireNonNull(fileName, "fileName");
        }

        @Override
        public ServiceRoles get() {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                InputStream inputStream = classLoader.getResourceAsStream(this.fileName);
                return inputStream != null ? (ServiceRoles)OBJECT_MAPPER.readValue(inputStream, ServiceRoles.class) : null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return new StringJoiner(", ", ResourcesServiceRolesSupplier.class.getSimpleName() + "[", "]").add("fileName='" + this.fileName + "'").toString();
        }
    }

    public static class ServiceRoles {
        private List<Role> roles;

        public List<Role> getRoles() {
            return this.roles;
        }

        public void setRoles(List<Role> roles) {
            this.roles = roles;
        }

        public String toString() {
            return new StringJoiner(", ", ServiceRoles.class.getSimpleName() + "[", "]").add("roles=" + this.roles).toString();
        }

        public static class Role {
            private String role;
            private List<String> permissions;

            public String getRole() {
                return this.role;
            }

            public void setRole(String role) {
                this.role = role;
            }

            public List<String> getPermissions() {
                return this.permissions;
            }

            public void setPermissions(List<String> permissions) {
                this.permissions = permissions;
            }

            public String toString() {
                return new StringJoiner(", ", Role.class.getSimpleName() + "[", "]").add("role='" + this.role + "'").add("permissions=" + this.permissions).toString();
            }
        }
    }
}

