/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.security.vault;

import com.bettercloud.vault.json.Json;
import com.bettercloud.vault.rest.Rest;
import com.bettercloud.vault.rest.RestException;
import java.io.InputStream;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import reactor.core.Exceptions;

public final class VaultServiceRolesInstaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(VaultServiceRolesInstaller.class);
    private static final String VAULT_TOKEN_HEADER = "X-Vault-Token";
    private String vaultAddress;
    private Supplier<String> vaultTokenSupplier;
    private Supplier<String> keyNameSupplier;
    private Function<String, String> roleNameBuilder;
    private String inputFileName = "service-roles.yaml";
    private String keyAlgorithm = "RS256";
    private String keyRotationPeriod = "1h";
    private String keyVerificationTtl = "1h";
    private String roleTtl = "1m";

    public VaultServiceRolesInstaller() {
    }

    private VaultServiceRolesInstaller(VaultServiceRolesInstaller other) {
        this.vaultAddress = other.vaultAddress;
        this.vaultTokenSupplier = other.vaultTokenSupplier;
        this.keyNameSupplier = other.keyNameSupplier;
        this.roleNameBuilder = other.roleNameBuilder;
        this.inputFileName = other.inputFileName;
        this.keyAlgorithm = other.keyAlgorithm;
        this.keyRotationPeriod = other.keyRotationPeriod;
        this.keyVerificationTtl = other.keyVerificationTtl;
        this.roleTtl = other.roleTtl;
    }

    private VaultServiceRolesInstaller copy() {
        return new VaultServiceRolesInstaller(this);
    }

    public VaultServiceRolesInstaller vaultAddress(String vaultAddress) {
        VaultServiceRolesInstaller c = this.copy();
        c.vaultAddress = vaultAddress;
        return c;
    }

    public VaultServiceRolesInstaller vaultTokenSupplier(Supplier<String> vaultTokenSupplier) {
        VaultServiceRolesInstaller c = this.copy();
        c.vaultTokenSupplier = vaultTokenSupplier;
        return c;
    }

    public VaultServiceRolesInstaller keyNameSupplier(Supplier<String> keyNameSupplier) {
        VaultServiceRolesInstaller c = this.copy();
        c.keyNameSupplier = keyNameSupplier;
        return c;
    }

    public VaultServiceRolesInstaller roleNameBuilder(Function<String, String> roleNameBuilder) {
        VaultServiceRolesInstaller c = this.copy();
        c.roleNameBuilder = roleNameBuilder;
        return c;
    }

    public VaultServiceRolesInstaller inputFileName(String inputFileName) {
        VaultServiceRolesInstaller c = this.copy();
        c.inputFileName = inputFileName;
        return c;
    }

    public VaultServiceRolesInstaller keyAlgorithm(String keyAlgorithm) {
        VaultServiceRolesInstaller c = this.copy();
        c.keyAlgorithm = keyAlgorithm;
        return c;
    }

    public VaultServiceRolesInstaller keyRotationPeriod(String keyRotationPeriod) {
        VaultServiceRolesInstaller c = this.copy();
        c.keyRotationPeriod = keyRotationPeriod;
        return c;
    }

    public VaultServiceRolesInstaller keyVerificationTtl(String keyVerificationTtl) {
        VaultServiceRolesInstaller c = this.copy();
        c.keyVerificationTtl = keyVerificationTtl;
        return c;
    }

    public VaultServiceRolesInstaller roleTtl(String roleTtl) {
        VaultServiceRolesInstaller c = this.copy();
        c.roleTtl = roleTtl;
        return c;
    }

    public void install() {
        if (VaultServiceRolesInstaller.isNullOrNoneOrEmpty(this.vaultAddress)) {
            return;
        }
        ServiceRoles serviceRoles = this.loadServiceRoles();
        if (serviceRoles == null) {
            return;
        }
        Rest rest = new Rest().header(VAULT_TOKEN_HEADER, this.vaultTokenSupplier.get());
        if (!serviceRoles.roles.isEmpty()) {
            String keyName = this.keyNameSupplier.get();
            this.createVaultIdentityKey(keyName, () -> rest.url(this.buildVaultIdentityKeyUri(keyName)));
            for (ServiceRoles.Role role : serviceRoles.roles) {
                String roleName = this.roleNameBuilder.apply(role.role);
                this.createVaultIdentityRole(keyName, roleName, role.permissions, () -> rest.url(this.buildVaultIdentityRoleUri(roleName)));
            }
        }
    }

    private ServiceRoles loadServiceRoles() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(this.inputFileName);
        return inputStream != null ? (ServiceRoles)new Yaml((BaseConstructor)new Constructor(ServiceRoles.class)).load(inputStream) : null;
    }

    private static void verifyOk(int status, String operation) {
        if (status != 200 && status != 204) {
            LOGGER.error("Not expected status ({}) returned on [{}]", (Object)status, (Object)operation);
            throw new IllegalStateException("Not expected status returned, status=" + status);
        }
    }

    private void createVaultIdentityKey(String keyName, Supplier<Rest> restSupplier) {
        LOGGER.debug("[createVaultIdentityKey] {}", (Object)keyName);
        byte[] body = Json.object().add("rotation_period", this.keyRotationPeriod).add("verification_ttl", this.keyVerificationTtl).add("allowed_client_ids", "*").add("algorithm", this.keyAlgorithm).toString().getBytes();
        try {
            VaultServiceRolesInstaller.verifyOk(restSupplier.get().body(body).post().getStatus(), "createVaultIdentityKey");
        }
        catch (RestException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private void createVaultIdentityRole(String keyName, String roleName, List<String> permissions, Supplier<Rest> restSupplier) {
        LOGGER.debug("[createVaultIdentityRole] {}", (Object)roleName);
        byte[] body = Json.object().add("key", keyName).add("template", VaultServiceRolesInstaller.createTemplate(permissions)).add("ttl", this.roleTtl).toString().getBytes();
        try {
            VaultServiceRolesInstaller.verifyOk(restSupplier.get().body(body).post().getStatus(), "createVaultIdentityRole");
        }
        catch (RestException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private static String createTemplate(List<String> permissions) {
        return Base64.getUrlEncoder().encodeToString(Json.object().add("permissions", String.join((CharSequence)",", permissions)).toString().getBytes());
    }

    private String buildVaultIdentityKeyUri(String keyName) {
        return new StringJoiner("/", this.vaultAddress, "").add("v1/identity/oidc/key").add(keyName).toString();
    }

    private String buildVaultIdentityRoleUri(String roleName) {
        return new StringJoiner("/", this.vaultAddress, "").add("v1/identity/oidc/role").add(roleName).toString();
    }

    private static boolean isNullOrNoneOrEmpty(String value) {
        return Objects.isNull(value) || "none".equalsIgnoreCase(value) || "null".equals(value) || value.isEmpty();
    }

    public static class ServiceRoles {
        private List<Role> roles;

        public List<Role> getRoles() {
            return this.roles;
        }

        public void setRoles(List<Role> roles) {
            this.roles = roles;
        }

        public static class Role {
            private String role;
            private List<String> permissions;

            public String getRole() {
                return this.role;
            }

            public void setRole(String role) {
                this.role = role;
            }

            public List<String> getPermissions() {
                return this.permissions;
            }

            public void setPermissions(List<String> permissions) {
                this.permissions = permissions;
            }
        }
    }
}

