/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.security.vault;

import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.VaultException;
import io.scalecube.config.utils.ThrowableUtil;
import io.scalecube.config.vault.EnvironmentVaultTokenSupplier;
import io.scalecube.config.vault.KubernetesVaultTokenSupplier;
import io.scalecube.utils.MaskUtil;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public final class VaultClientTokenSupplier {
    private static final Logger LOGGER = LoggerFactory.getLogger(VaultClientTokenSupplier.class);
    private String vaultAddress;
    private String vaultToken;
    private String vaultRole;

    public VaultClientTokenSupplier() {
    }

    private VaultClientTokenSupplier(VaultClientTokenSupplier other) {
        this.vaultAddress = other.vaultAddress;
        this.vaultToken = other.vaultToken;
        this.vaultRole = other.vaultRole;
    }

    private VaultClientTokenSupplier copy() {
        return new VaultClientTokenSupplier(this);
    }

    private void validate() {
        if (VaultClientTokenSupplier.isNullOrNoneOrEmpty(this.vaultAddress)) {
            throw new IllegalArgumentException("Vault address is required");
        }
        if (VaultClientTokenSupplier.isNullOrNoneOrEmpty(this.vaultToken) && VaultClientTokenSupplier.isNullOrNoneOrEmpty(this.vaultRole)) {
            throw new IllegalArgumentException("Vault auth scheme is required (specify either VAULT_ROLE or VAULT_TOKEN)");
        }
    }

    public VaultClientTokenSupplier vaultAddress(String vaultAddress) {
        VaultClientTokenSupplier c = this.copy();
        c.vaultAddress = vaultAddress;
        return c;
    }

    public VaultClientTokenSupplier vaultToken(String vaultToken) {
        VaultClientTokenSupplier c = this.copy();
        c.vaultToken = vaultToken;
        return c;
    }

    public VaultClientTokenSupplier vaultRole(String vaultRole) {
        VaultClientTokenSupplier c = this.copy();
        c.vaultRole = vaultRole;
        return c;
    }

    public Mono<String> getToken() {
        return Mono.fromRunnable(this::validate).then(Mono.fromCallable(this::getToken0)).subscribeOn(Schedulers.boundedElastic()).doOnSubscribe(s -> LOGGER.debug("[getToken] Getting vault client token")).doOnSuccess(s -> LOGGER.debug("[getToken][success] result: {}", (Object)MaskUtil.mask((String)s))).doOnError(th -> LOGGER.error("[getToken][error] cause: {}", (Object)th.toString()));
    }

    private String getToken0() {
        try {
            VaultConfig vaultConfig;
            EnvironmentVaultTokenSupplier vaultTokenSupplier;
            if (!VaultClientTokenSupplier.isNullOrNoneOrEmpty(this.vaultRole)) {
                if (!VaultClientTokenSupplier.isNullOrNoneOrEmpty(this.vaultToken)) {
                    LOGGER.warn("Taking KubernetesVaultTokenSupplier by precedence rule, ignoring EnvironmentVaultTokenSupplier (specify either VAULT_ROLE or VAULT_TOKEN, not both)");
                }
                vaultTokenSupplier = new KubernetesVaultTokenSupplier().vaultRole(this.vaultRole);
                vaultConfig = new VaultConfig().address(this.vaultAddress).build();
            } else {
                vaultTokenSupplier = new EnvironmentVaultTokenSupplier();
                vaultConfig = new VaultConfig().address(this.vaultAddress).token(this.vaultToken).build();
            }
            return vaultTokenSupplier.getToken(vaultConfig);
        }
        catch (VaultException e) {
            throw ThrowableUtil.propagate((Throwable)e);
        }
    }

    private static boolean isNullOrNoneOrEmpty(String value) {
        return Objects.isNull(value) || "none".equalsIgnoreCase(value) || "null".equals(value) || value.isEmpty();
    }
}

