/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.security.tokens.jwt;

import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.Locator;
import io.scalecube.security.tokens.jwt.JwtToken;
import io.scalecube.security.tokens.jwt.JwtTokenException;
import io.scalecube.security.tokens.jwt.JwtTokenResolver;
import java.security.Key;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonwebtokenResolver
implements JwtTokenResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonwebtokenResolver.class);
    private final Locator<Key> keyLocator;

    public JsonwebtokenResolver(Locator<Key> keyLocator) {
        this.keyLocator = Objects.requireNonNull(keyLocator, "keyLocator");
    }

    @Override
    public CompletableFuture<JwtToken> resolve(String token) {
        return CompletableFuture.supplyAsync(() -> {
            Jws claimsJws = Jwts.parser().keyLocator(this.keyLocator).build().parseSignedClaims((CharSequence)token);
            return new JwtToken((Map<String, Object>)claimsJws.getHeader(), (Map)claimsJws.getPayload());
        }).handle((jwtToken, ex) -> {
            if (jwtToken != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Resolved token: {}", (Object)JsonwebtokenResolver.mask(token));
                }
                return jwtToken;
            }
            if (ex != null) {
                if (ex instanceof JwtTokenException) {
                    throw (JwtTokenException)ex;
                }
                throw new JwtTokenException("Failed to resolve token: " + JsonwebtokenResolver.mask(token), (Throwable)ex);
            }
            return null;
        });
    }

    private static String mask(String data) {
        if (data == null || data.length() < 5) {
            return "*****";
        }
        return data.replace(data.substring(2, data.length() - 2), "***");
    }
}

