/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.organization.tokens;

import io.scalecube.account.api.ApiKey;
import io.scalecube.organization.jwt.WebToken;
import java.security.Key;
import java.util.Map;

public class JwtApiKey
extends ApiKey {
    public JwtApiKey() {
    }

    public JwtApiKey(String name, Map<String, String> claims, String apiKey, String keyId) {
        this.name = name;
        this.claims = claims;
        this.key = apiKey;
        this.keyId = keyId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String issuer;
        private String subject;
        private Map<String, String> claims;
        private String id;
        private String name;
        private Long tokenTimeToLiveInMillis;
        private String audience;
        private String keyId;
        private Key signingKey;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder claims(Map<String, String> claims) {
            this.claims = claims;
            return this;
        }

        public Builder expiration(Long tokenTimeToLiveInMillis) {
            this.tokenTimeToLiveInMillis = tokenTimeToLiveInMillis;
            return this;
        }

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public Builder signingKey(Key signingKey) {
            this.signingKey = signingKey;
            return this;
        }

        public Builder audience(String audience) {
            this.audience = audience;
            return this;
        }

        public ApiKey build() {
            WebToken jwt = new WebToken(this.issuer, this.subject);
            String apiKey = jwt.createToken(this.id, this.audience, this.tokenTimeToLiveInMillis, this.keyId, this.signingKey, this.claims);
            return new JwtApiKey(this.name, this.claims, apiKey, this.keyId);
        }
    }
}

