/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.organization.server;

import com.couchbase.client.java.AsyncBucket;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.CouchbaseCluster;
import io.scalecube.account.api.OrganizationService;
import io.scalecube.organization.OrganizationServiceImpl;
import io.scalecube.organization.config.AppConfiguration;
import io.scalecube.organization.repository.couchbase.CouchbaseOrganizationsRepository;
import io.scalecube.organization.repository.couchbase.CouchbaseSettings;
import io.scalecube.organization.server.DiscoveryOptions;
import io.scalecube.organization.tokens.Auth0PublicKeyProvider;
import io.scalecube.organization.tokens.TokenVerifierImpl;
import io.scalecube.organization.tokens.store.VaultKeyStore;
import io.scalecube.services.Microservices;
import io.scalecube.services.discovery.ScalecubeServiceDiscovery;
import io.scalecube.services.transport.rsocket.RSocketServiceTransport;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class OrganizationServiceRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrganizationServiceRunner.class);

    public static void main(String[] args) throws Exception {
        OrganizationServiceRunner.start();
        Thread.currentThread().join();
    }

    private static void start() {
        DiscoveryOptions discoveryOptions = (DiscoveryOptions)AppConfiguration.configRegistry().objectProperty("io.scalecube.organization", DiscoveryOptions.class).value().orElseThrow(() -> new IllegalStateException("Couldn't load discovery options"));
        LOGGER.info("Starting organization service on {}", (Object)discoveryOptions);
        Microservices.builder().discovery(serviceEndpoint -> new ScalecubeServiceDiscovery(serviceEndpoint).options(opts -> opts.seedMembers(discoveryOptions.seeds()).port(discoveryOptions.discoveryPort().intValue()).memberHost(discoveryOptions.memberHost()).memberPort(discoveryOptions.memberPort()))).transport(opts -> opts.serviceTransport(RSocketServiceTransport::new).port(discoveryOptions.servicePort())).services(new Object[]{OrganizationServiceRunner.createOrganizationService()}).startAwait();
    }

    private static OrganizationService createOrganizationService() {
        CouchbaseSettings settings = (CouchbaseSettings)AppConfiguration.configRegistry().objectProperty(OrganizationServiceRunner.couchbaseSettingsBindingMap(), CouchbaseSettings.class).value().orElseThrow(() -> new IllegalStateException("Couldn't load couchbase settings"));
        CouchbaseCluster cluster = CouchbaseCluster.create(settings.hosts());
        AsyncBucket bucket = (AsyncBucket)Mono.fromCallable(() -> OrganizationServiceRunner.lambda$createOrganizationService$5((Cluster)cluster, settings)).retryBackoff(3L, Duration.ofSeconds(1L)).block(Duration.ofSeconds(30L));
        CouchbaseOrganizationsRepository repository = new CouchbaseOrganizationsRepository(bucket);
        VaultKeyStore keyStore = new VaultKeyStore();
        TokenVerifierImpl tokenVerifier = new TokenVerifierImpl(new Auth0PublicKeyProvider());
        return new OrganizationServiceImpl(repository, keyStore, tokenVerifier);
    }

    private static Map<String, String> couchbaseSettingsBindingMap() {
        HashMap<String, String> bindingMap = new HashMap<String, String>();
        bindingMap.put("hosts", "couchbase.hosts");
        bindingMap.put("username", "couchbase.username");
        bindingMap.put("password", "couchbase.password");
        bindingMap.put("organizationsBucketName", "organizations.bucket");
        return bindingMap;
    }

    private static /* synthetic */ AsyncBucket lambda$createOrganizationService$5(Cluster cluster, CouchbaseSettings settings) throws Exception {
        return cluster.authenticate(settings.username(), settings.password()).openBucket(settings.organizationsBucketName()).async();
    }
}

