/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.organization.repository.couchbase;

import com.couchbase.client.java.AsyncBucket;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.RawJsonDocument;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.query.AsyncN1qlQueryResult;
import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.query.Select;
import com.couchbase.client.java.query.SimpleN1qlQuery;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.query.dsl.Expression;
import io.scalecube.organization.domain.Entity;
import io.scalecube.organization.repository.Repository;
import io.scalecube.organization.repository.couchbase.CouchbaseExceptionTranslator;
import io.scalecube.organization.repository.couchbase.JacksonTranslationService;
import io.scalecube.organization.repository.couchbase.TranslationService;
import io.scalecube.organization.repository.exception.DataRetrievalFailureException;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import rx.Observable;
import rx.RxReactiveStreams;

abstract class CouchbaseRepository<T extends Entity>
implements Repository<T, String> {
    private static final String ID_CANNOT_BE_NULL = "id cannot be null";
    private static final String SELECT_COUNT_BY_DOCUMENT_FIELD_QUERY = "select count(id) as count from %s where %s = '%s'";
    private final TranslationService translationService = new JacksonTranslationService();
    private final AsyncBucket bucket;
    private final Class<T> type;

    CouchbaseRepository(AsyncBucket bucket, Class<T> type) {
        this.bucket = Objects.requireNonNull(bucket, "bucket cannot be null");
        this.type = Objects.requireNonNull(type, "entity type cannot be null");
    }

    @Override
    public Mono<Boolean> existByProperty(String propertyName, Object propertyValue) {
        return Mono.fromRunnable(() -> Objects.requireNonNull(propertyName, "property name cannot be null")).then(Mono.fromCallable(() -> N1qlQuery.simple((String)String.format(SELECT_COUNT_BY_DOCUMENT_FIELD_QUERY, this.bucket.name(), propertyName, propertyValue)))).flatMap(query -> Mono.from((Publisher)RxReactiveStreams.toPublisher((Observable)this.bucket.query((N1qlQuery)query).flatMap(AsyncN1qlQueryResult::rows)))).map(row -> row.value().getInt("count") > 0);
    }

    @Override
    public Mono<T> findById(String id) {
        return Mono.fromRunnable(() -> Objects.requireNonNull(id, ID_CANNOT_BE_NULL)).then(Mono.defer(() -> Mono.from((Publisher)RxReactiveStreams.toPublisher((Observable)this.bucket.get(id))))).map(this::toEntity).onErrorMap(CouchbaseExceptionTranslator::translateExceptionIfPossible);
    }

    private T toEntity(JsonDocument document) {
        Entity entity = (Entity)this.translationService.decode(((JsonObject)document.content()).toString(), this.type);
        entity.version(document.cas());
        return (T)entity;
    }

    @Override
    public Mono<Boolean> existsById(String id) {
        return Mono.fromRunnable(() -> Objects.requireNonNull(id, ID_CANNOT_BE_NULL)).then(Mono.defer(() -> Mono.from((Publisher)RxReactiveStreams.toPublisher((Observable)this.bucket.exists(id))))).onErrorMap(CouchbaseExceptionTranslator::translateExceptionIfPossible);
    }

    @Override
    public Mono<T> save(String id, T entity) {
        return Mono.fromRunnable(() -> {
            Objects.requireNonNull(id, ID_CANNOT_BE_NULL);
            Objects.requireNonNull(entity, this.type.getSimpleName() + " cannot be null");
        }).then(Mono.fromCallable(() -> RawJsonDocument.create((String)id, (String)this.translationService.encode(entity), (long)entity.version()))).flatMap(document -> {
            if (entity.version() == 0L) {
                return Mono.from((Publisher)RxReactiveStreams.toPublisher((Observable)this.bucket.insert((Document)document)));
            }
            return Mono.from((Publisher)RxReactiveStreams.toPublisher((Observable)this.bucket.replace((Document)document)));
        }).onErrorMap(CouchbaseExceptionTranslator::translateExceptionIfPossible).then(Mono.just(entity));
    }

    @Override
    public Mono<Void> deleteById(String id) {
        return Mono.fromRunnable(() -> Objects.requireNonNull(id, ID_CANNOT_BE_NULL)).then(Mono.defer(() -> Mono.from((Publisher)RxReactiveStreams.toPublisher((Observable)this.bucket.remove(id))))).onErrorMap(CouchbaseExceptionTranslator::translateExceptionIfPossible).then();
    }

    @Override
    public Flux<T> findAll() {
        SimpleN1qlQuery query = N1qlQuery.simple((Statement)Select.select((String[])new String[]{"*"}).from(Expression.i((String[])new String[]{this.bucket.name()})));
        return Flux.from((Publisher)RxReactiveStreams.toPublisher((Observable)this.bucket.query((N1qlQuery)query).flatMap(result -> result.rows().mergeWith(result.errors().flatMap(error -> Observable.error((Throwable)new DataRetrievalFailureException("N1QL error: " + error.toString())))).flatMap(row -> Observable.just(this.translationService.decode(row.value().get(this.bucket.name()).toString(), this.type)))))).onErrorMap(CouchbaseExceptionTranslator::translateExceptionIfPossible);
    }
}

