/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.organization.domain;

import io.scalecube.account.api.ApiKey;
import io.scalecube.account.api.OrganizationMember;
import io.scalecube.account.api.Role;
import io.scalecube.organization.domain.Entity;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;

public class Organization
extends Entity {
    private String name;
    private String email;
    private Set<OrganizationMember> members = new HashSet<OrganizationMember>();
    private Set<ApiKey> apiKeys = new HashSet<ApiKey>();

    Organization() {
    }

    public Organization(String id, String name, String email, String creatorUserId) {
        this.id = Objects.requireNonNull(id, "organization id cannot be null");
        this.name = Objects.requireNonNull(name, "organization name cannot be null");
        this.email = Objects.requireNonNull(email, "organization email cannot be null");
        this.addMember(new OrganizationMember(Objects.requireNonNull(creatorUserId, "organization creator id cannot be null"), Role.Owner.name()));
    }

    public String name() {
        return this.name;
    }

    public String email() {
        return this.email;
    }

    public Set<OrganizationMember> members() {
        return Collections.unmodifiableSet(this.members);
    }

    public Set<ApiKey> apiKeys() {
        return Collections.unmodifiableSet(this.apiKeys);
    }

    public void changeName(String name) {
        this.name = name;
    }

    public void changeEmail(String email) {
        this.email = email;
    }

    public void addMember(OrganizationMember member) {
        this.members.add(member);
    }

    public void removeMember(String userId) {
        this.members.removeIf(member -> member.id().equals(userId));
    }

    public boolean isMember(String userId) {
        return this.members.stream().anyMatch(member -> member.id().equals(userId));
    }

    public void updateMemberRole(String userId, Role role) {
        this.removeMember(userId);
        this.addMember(new OrganizationMember(userId, role.name()));
    }

    public void addApiKey(ApiKey apiKey) {
        this.apiKeys.add(apiKey);
    }

    public void removeApiKey(String apiKeyName) {
        this.apiKeys.removeIf(apiKey -> apiKey.name().equals(apiKeyName));
    }

    public String toString() {
        return new StringJoiner(", ", Organization.class.getSimpleName() + "[", "]").add("id='" + this.id + "'").add("name='" + this.name + "'").add("email='" + this.email + "'").add("members=" + this.members).toString();
    }
}

