/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.metrics.mimir;

import io.scalecube.metrics.Delay;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.agrona.LangUtil;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentTerminationException;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.ManyToOneConcurrentArrayQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.Snappy;
import prometheus.Remote;

class MimirPublisherAgent
implements Agent {
    private static final Logger LOGGER = LoggerFactory.getLogger(MimirPublisherAgent.class);
    private final String url;
    private final int writeLimit;
    private final ManyToOneConcurrentArrayQueue<Remote.WriteRequest> writeQueue;
    private final Delay retryInterval;
    private final Delay publishInterval;
    private ExecutorService executor;
    private HttpClient httpClient;
    private CompletableFuture<HttpResponse<String>> future;
    private State state = State.CLOSED;

    MimirPublisherAgent(String url, EpochClock epochClock, Duration retryInterval, Duration publishInterval, int writeLimit, ManyToOneConcurrentArrayQueue<Remote.WriteRequest> writeQueue) {
        this.url = url;
        this.writeLimit = writeLimit;
        this.writeQueue = writeQueue;
        this.retryInterval = new Delay(epochClock, retryInterval.toMillis());
        this.publishInterval = new Delay(epochClock, publishInterval.toMillis());
    }

    public String roleName() {
        return "MimirPublisherAgent";
    }

    public void onStart() {
        if (this.state != State.CLOSED) {
            throw new AgentTerminationException("Illegal state: " + String.valueOf((Object)this.state));
        }
        this.state(State.INIT);
    }

    public int doWork() throws Exception {
        try {
            return switch (this.state) {
                case State.INIT -> this.init();
                case State.RUNNING -> this.running();
                case State.CLEANUP -> this.cleanup();
                default -> throw new AgentTerminationException("Unknown state: " + String.valueOf((Object)this.state));
            };
        }
        catch (AgentTerminationException e) {
            throw e;
        }
        catch (Exception e) {
            this.state(State.CLEANUP);
            throw e;
        }
    }

    private int init() {
        if (this.retryInterval.isNotOverdue()) {
            return 0;
        }
        this.executor = Executors.newSingleThreadExecutor(r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            return thread;
        });
        this.httpClient = HttpClient.newBuilder().executor(this.executor).build();
        this.publishInterval.delay();
        this.state(State.RUNNING);
        return 1;
    }

    private int running() throws Exception {
        double fillRate = (double)this.writeQueue.size() / (double)this.writeQueue.capacity();
        if (this.publishInterval.isOverdue() || fillRate > 0.5) {
            this.publishInterval.delay();
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
            Remote.WriteRequest.Builder builder = Remote.WriteRequest.newBuilder();
            this.writeQueue.drain(request -> builder.addAllTimeseries(request.getTimeseriesList()), this.writeLimit);
            Remote.WriteRequest writeRequest = builder.build();
            if (writeRequest.getTimeseriesCount() > 0) {
                this.future = this.send(writeRequest);
            }
        }
        if (this.future != null && this.future.isDone()) {
            HttpResponse<String> response = this.future.get();
            if (response.statusCode() != 200) {
                LOGGER.warn("Failed to push metrics: HTTP {}, body: {}", (Object)response.statusCode(), (Object)response.body());
            }
            this.future = null;
        }
        return 0;
    }

    private CompletableFuture<HttpResponse<String>> send(Remote.WriteRequest request) {
        byte[] compressedPayload;
        byte[] payload = request.toByteArray();
        try {
            compressedPayload = Snappy.compress((byte[])payload);
        }
        catch (IOException e) {
            LangUtil.rethrowUnchecked((Throwable)e);
            return null;
        }
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(this.url)).header("Content-Type", "application/x-protobuf").header("Content-Encoding", "snappy").header("X-Prometheus-Remote-Write-Version", "0.1.0").POST(HttpRequest.BodyPublishers.ofByteArray(compressedPayload)).build();
        return this.httpClient.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofString());
    }

    private int cleanup() {
        State previous;
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        this.httpClient = null;
        this.executor = null;
        if (this.future != null) {
            this.future.cancel(true);
            this.future = null;
        }
        if ((previous = this.state) != State.CLOSED) {
            this.retryInterval.delay();
            this.state(State.INIT);
        }
        return 1;
    }

    public void onClose() {
        this.state(State.CLOSED);
        this.cleanup();
    }

    private void state(State state) {
        LOGGER.debug("[{}][state] {}->{}", new Object[]{this.roleName(), this.state, state});
        this.state = state;
    }

    public static enum State {
        INIT,
        RUNNING,
        CLEANUP,
        CLOSED;

    }
}

