/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.metrics.mimir;

import io.scalecube.metrics.mimir.MimirPublisherAgent;
import java.time.Duration;
import java.util.ConcurrentModificationException;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.ManyToOneConcurrentArrayQueue;
import org.agrona.concurrent.SystemEpochClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import prometheus.Remote;

public class MimirPublisher
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MimirPublisher.class);
    private final Context context;
    private final AgentInvoker agentInvoker;
    private final AgentRunner agentRunner;

    private MimirPublisher(Context context) {
        context.conclude();
        this.context = context;
        MimirPublisherAgent agent = new MimirPublisherAgent(context.url(), context.epochClock(), context.retryInterval(), context.publishInterval(), context.writeLimit(), context.writeQueue());
        if (context.useAgentInvoker()) {
            this.agentRunner = null;
            this.agentInvoker = new AgentInvoker(context.errorHandler(), null, (Agent)agent);
        } else {
            this.agentInvoker = null;
            this.agentRunner = new AgentRunner(context.idleStrategy(), context.errorHandler(), null, (Agent)agent);
        }
    }

    public static MimirPublisher launch() {
        return MimirPublisher.launch(new Context());
    }

    public static MimirPublisher launch(Context context) {
        MimirPublisher metricsReceiver = new MimirPublisher(context);
        if (metricsReceiver.agentInvoker != null) {
            metricsReceiver.agentInvoker.start();
        } else {
            AgentRunner.startOnThread((AgentRunner)metricsReceiver.agentRunner);
        }
        return metricsReceiver;
    }

    public Context context() {
        return this.context;
    }

    public AgentInvoker agentInvoker() {
        return this.agentInvoker;
    }

    public WriteProxy proxy() {
        return new WriteProxy(this.context.writeQueue());
    }

    @Override
    public void close() {
        CloseHelper.quietCloseAll((AutoCloseable[])new AutoCloseable[]{this.agentInvoker, this.agentRunner});
    }

    public static class Context {
        private static final AtomicIntegerFieldUpdater<Context> IS_CONCLUDED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Context.class, "isConcluded");
        private volatile int isConcluded;
        private Duration retryInterval;
        private Duration publishInterval;
        private EpochClock epochClock;
        private boolean useAgentInvoker;
        private ErrorHandler errorHandler;
        private IdleStrategy idleStrategy;
        private String url;
        private Integer writeLimit;
        private Integer writeQueueCapacity;
        private ManyToOneConcurrentArrayQueue<Remote.WriteRequest> writeQueue;

        private void conclude() {
            if (0 != IS_CONCLUDED_UPDATER.getAndSet(this, 1)) {
                throw new ConcurrentModificationException();
            }
            if (this.retryInterval == null) {
                this.retryInterval = Duration.ofSeconds(3L);
            }
            if (this.publishInterval == null) {
                this.publishInterval = Duration.ofSeconds(5L);
            }
            if (this.epochClock == null) {
                this.epochClock = SystemEpochClock.INSTANCE;
            }
            if (this.errorHandler == null) {
                this.errorHandler = ex -> LOGGER.error("Exception occurred: ", ex);
            }
            if (this.idleStrategy == null) {
                this.idleStrategy = new BackoffIdleStrategy();
            }
            Objects.requireNonNull(this.url, "url");
            if (this.writeLimit == null) {
                this.writeLimit = 100;
            }
            if (this.writeQueueCapacity == null) {
                this.writeQueueCapacity = 65536;
            }
            if (this.writeQueue == null) {
                this.writeQueue = new ManyToOneConcurrentArrayQueue(this.writeQueueCapacity.intValue());
            }
        }

        public Duration retryInterval() {
            return this.retryInterval;
        }

        public Context retryInterval(Duration retryInterval) {
            this.retryInterval = retryInterval;
            return this;
        }

        public Duration publishInterval() {
            return this.publishInterval;
        }

        public Context publishInterval(Duration publishInterval) {
            this.publishInterval = publishInterval;
            return this;
        }

        public EpochClock epochClock() {
            return this.epochClock;
        }

        public Context epochClock(EpochClock epochClock) {
            this.epochClock = epochClock;
            return this;
        }

        public boolean useAgentInvoker() {
            return this.useAgentInvoker;
        }

        public Context useAgentInvoker(boolean useAgentInvoker) {
            this.useAgentInvoker = useAgentInvoker;
            return this;
        }

        public ErrorHandler errorHandler() {
            return this.errorHandler;
        }

        public Context errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public IdleStrategy idleStrategy() {
            return this.idleStrategy;
        }

        public Context idleStrategy(IdleStrategy idleStrategy) {
            this.idleStrategy = idleStrategy;
            return this;
        }

        public String url() {
            return this.url;
        }

        public Context url(String url) {
            this.url = url;
            return this;
        }

        public Integer writeLimit() {
            return this.writeLimit;
        }

        public Context writeLimit(Integer writeLimit) {
            this.writeLimit = writeLimit;
            return this;
        }

        public Integer writeQueueCapacity() {
            return this.writeQueueCapacity;
        }

        public Context writeQueueCapacity(Integer writeQueueCapacity) {
            this.writeQueueCapacity = writeQueueCapacity;
            return this;
        }

        public ManyToOneConcurrentArrayQueue<Remote.WriteRequest> writeQueue() {
            return this.writeQueue;
        }

        public Context writeQueue(ManyToOneConcurrentArrayQueue<Remote.WriteRequest> writeQueue) {
            this.writeQueue = writeQueue;
            return this;
        }

        public String toString() {
            return new StringJoiner(", ", Context.class.getSimpleName() + "[", "]").add("retryInterval=" + String.valueOf(this.retryInterval)).add("publishInterval=" + String.valueOf(this.publishInterval)).add("epochClock=" + String.valueOf(this.epochClock)).add("useAgentInvoker=" + this.useAgentInvoker).add("errorHandler=" + String.valueOf(this.errorHandler)).add("idleStrategy=" + String.valueOf(this.idleStrategy)).add("url='" + this.url + "'").add("writeLimit=" + this.writeLimit).add("writeQueueCapacity=" + this.writeQueueCapacity).add("writeQueue=" + String.valueOf(this.writeQueue)).toString();
        }
    }

    public static class WriteProxy {
        private final ManyToOneConcurrentArrayQueue<Remote.WriteRequest> writeQueue;

        private WriteProxy(ManyToOneConcurrentArrayQueue<Remote.WriteRequest> writeQueue) {
            this.writeQueue = writeQueue;
        }

        public void push(Remote.WriteRequest request) {
            this.writeQueue.offer((Object)request);
        }
    }
}

