/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.gateway.websocket.message;

import io.netty.buffer.ByteBuf;
import io.scalecube.gateway.websocket.message.Signal;
import io.scalecube.services.api.ServiceMessage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class GatewayMessage {
    public static final String QUALIFIER_FIELD = "q";
    public static final String STREAM_ID_FIELD = "sid";
    public static final String SIGNAL_FIELD = "sig";
    public static final String DATA_FIELD = "d";
    public static final String INACTIVITY_FIELD = "i";
    public static final String RATE_LIMIT_FIELD = "rlimit";
    private final Map<String, String> headers;
    private final Object data;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder from(GatewayMessage message) {
        return new Builder().headers(message.headers).data(message.data);
    }

    public static Builder from(ServiceMessage message) {
        return new Builder().headers(message.headers()).data(message.data());
    }

    private GatewayMessage(Builder builder) {
        this.data = builder.data;
        this.headers = Collections.unmodifiableMap(new HashMap(builder.headers));
    }

    public static ServiceMessage toServiceMessage(GatewayMessage message) {
        return ServiceMessage.builder().headers(message.headers).data(message.data).build();
    }

    public String qualifier() {
        return this.headers.get(QUALIFIER_FIELD);
    }

    public Long streamId() {
        String value = this.headers.get(STREAM_ID_FIELD);
        return value != null ? Long.valueOf(Long.parseLong(value)) : null;
    }

    public Integer signal() {
        String value = this.headers.get(SIGNAL_FIELD);
        return value != null ? Integer.valueOf(value) : null;
    }

    public <T> T data() {
        return (T)this.data;
    }

    public Integer inactivity() {
        String value = this.headers.get(INACTIVITY_FIELD);
        return value != null ? Integer.valueOf(value) : null;
    }

    public Integer rateLimit() {
        String value = this.headers.get(RATE_LIMIT_FIELD);
        return value != null ? Integer.valueOf(value) : null;
    }

    public boolean hasSignal(Signal signal) {
        String value = this.headers.get(SIGNAL_FIELD);
        return value != null && Integer.parseInt(value) == signal.code();
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public boolean hasHeader(String name) {
        return this.headers.containsKey(name);
    }

    public String toString() {
        return "GatewayMessage {headers: " + this.headers + ", data: " + this.dataToString() + '}';
    }

    private Object dataToString() {
        if (this.data instanceof ByteBuf) {
            return "bb-" + ((ByteBuf)this.data).readableBytes();
        }
        if (this.data instanceof String) {
            return "str-" + ((String)this.data).length();
        }
        return this.data;
    }

    public static class Builder {
        private Map<String, String> headers = new HashMap<String, String>(1);
        private Object data;

        Builder() {
        }

        public Builder qualifier(String qualifier) {
            return this.header(GatewayMessage.QUALIFIER_FIELD, qualifier);
        }

        public Builder streamId(Long streamId) {
            return this.header(GatewayMessage.STREAM_ID_FIELD, streamId);
        }

        public Builder signal(Integer signal) {
            return this.header(GatewayMessage.SIGNAL_FIELD, signal);
        }

        public Builder signal(Signal signal) {
            return this.signal(signal.code());
        }

        public Builder inactivity(Integer inactivity) {
            return this.header(GatewayMessage.INACTIVITY_FIELD, inactivity);
        }

        public Builder rateLimit(Integer rateLimit) {
            return this.header(GatewayMessage.RATE_LIMIT_FIELD, rateLimit);
        }

        public Builder data(Object data) {
            this.data = data;
            return this;
        }

        public Builder header(String key, String value) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(value);
            this.headers.put(key, value);
            return this;
        }

        public Builder header(String key, Object value) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(value);
            this.headers.put(key, value.toString());
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            headers.forEach(this::header);
            return this;
        }

        public GatewayMessage build() {
            return new GatewayMessage(this);
        }
    }
}

