/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.gateway.websocket.message;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.scalecube.gateway.ReferenceCountUtil;
import io.scalecube.gateway.websocket.message.GatewayMessage;
import io.scalecube.services.exceptions.MessageCodecException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayMessageCodec {
    private static final Logger LOGGER = LoggerFactory.getLogger(GatewayMessageCodec.class);
    private static final ObjectMapper objectMapper = GatewayMessageCodec.objectMapper();
    private static final MappingJsonFactory jsonFactory = new MappingJsonFactory(objectMapper);
    private final boolean releaseDataOnEncode;

    public GatewayMessageCodec() {
        this(true);
    }

    public GatewayMessageCodec(boolean releaseDataOnEncode) {
        this.releaseDataOnEncode = releaseDataOnEncode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuf encode(GatewayMessage message) throws MessageCodecException {
        ByteBuf byteBuf = ByteBufAllocator.DEFAULT.buffer();
        try (JsonGenerator generator = jsonFactory.createGenerator((OutputStream)new ByteBufOutputStream(byteBuf), JsonEncoding.UTF8);){
            generator.writeStartObject();
            block23: for (Map.Entry<String, String> header : message.headers().entrySet()) {
                String fieldName = header.getKey();
                String value = header.getValue();
                switch (fieldName) {
                    case "sid": 
                    case "sig": 
                    case "i": 
                    case "rlimit": {
                        generator.writeNumberField(fieldName, Long.parseLong(value));
                        continue block23;
                    }
                }
                generator.writeStringField(fieldName, value);
            }
            Object data = message.data();
            if (data != null) {
                if (data instanceof ByteBuf) {
                    ByteBuf dataBin = (ByteBuf)data;
                    if (dataBin.isReadable()) {
                        try {
                            generator.writeFieldName("d");
                            generator.writeRaw(":");
                            generator.flush();
                            byteBuf.writeBytes(dataBin);
                        }
                        finally {
                            if (this.releaseDataOnEncode) {
                                ReferenceCountUtil.safestRelease((Object)dataBin);
                            }
                        }
                    }
                } else {
                    generator.writeObjectField("d", data);
                }
            }
            generator.writeEndObject();
        }
        catch (Throwable ex) {
            ReferenceCountUtil.safestRelease((Object)byteBuf);
            Optional.ofNullable(message.data()).ifPresent(ReferenceCountUtil::safestRelease);
            LOGGER.error("Failed to encode message: {}", (Object)message, (Object)ex);
            throw new MessageCodecException("Failed to encode message", ex);
        }
        return byteBuf;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GatewayMessage decode(ByteBuf byteBuf) throws MessageCodecException {
        try (ByteBufInputStream stream = new ByteBufInputStream(byteBuf, true);){
            JsonParser jp = jsonFactory.createParser((InputStream)stream);
            GatewayMessage.Builder result = GatewayMessage.builder();
            JsonToken current = jp.nextToken();
            if (current != JsonToken.START_OBJECT) {
                throw new MessageCodecException("Root should be object", null);
            }
            long dataStart = 0L;
            long dataEnd = 0L;
            while (jp.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = jp.getCurrentName();
                current = jp.nextToken();
                if (current == JsonToken.VALUE_NULL) continue;
                if (fieldName.equals("d")) {
                    dataStart = jp.getTokenLocation().getByteOffset();
                    if (current.isScalarValue()) {
                        if (!current.isNumeric() && !current.isBoolean()) {
                            jp.getValueAsString();
                        }
                    } else if (current.isStructStart()) {
                        jp.skipChildren();
                    }
                    dataEnd = jp.getCurrentLocation().getByteOffset();
                    continue;
                }
                result.header(fieldName, jp.getValueAsString());
            }
            if (dataEnd > dataStart) {
                result.data(byteBuf.copy((int)dataStart, (int)(dataEnd - dataStart)));
            }
            GatewayMessage gatewayMessage = result.build();
            return gatewayMessage;
        }
        catch (Throwable ex) {
            throw new MessageCodecException("Failed to decode message", ex);
        }
    }

    private static ObjectMapper objectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
        mapper.registerModule((Module)new JavaTimeModule());
        return mapper;
    }
}

