/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.gateway.websocket;

import io.scalecube.gateway.ReferenceCountUtil;
import io.scalecube.gateway.websocket.message.GatewayMessage;
import io.scalecube.services.exceptions.BadRequestException;
import java.util.Objects;
import java.util.Optional;

public class WebsocketRequestException
extends RuntimeException {
    private final GatewayMessage request;

    private WebsocketRequestException(Throwable cause, GatewayMessage request) {
        super(Objects.requireNonNull(cause, "cause must be not null"));
        this.request = Objects.requireNonNull(request, "request message must be not null");
    }

    public static WebsocketRequestException newBadRequest(String errorMessage, GatewayMessage request) {
        return new WebsocketRequestException((Throwable)new BadRequestException(errorMessage), request);
    }

    public GatewayMessage request() {
        return this.request;
    }

    public WebsocketRequestException releaseRequest() {
        Optional.ofNullable(this.request.data()).ifPresent(ReferenceCountUtil::safestRelease);
        return this;
    }
}

