/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.gateway.websocket.message;

import io.netty.buffer.ByteBuf;
import io.scalecube.gateway.websocket.message.Signal;
import io.scalecube.services.api.ServiceMessage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class GatewayMessage {
    public static final String QUALIFIER_FIELD = "q";
    public static final String STREAM_ID_FIELD = "sid";
    public static final String SIGNAL_FIELD = "sig";
    public static final String DATA_FIELD = "d";
    public static final String INACTIVITY_FIELD = "i";
    private final Map<String, String> headers;
    private final Object data;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder from(GatewayMessage msg) {
        return new Builder().headers(msg.headers).data(msg.data);
    }

    public static Builder from(ServiceMessage serviceMessage) {
        Builder builder = new Builder();
        if (serviceMessage.hasData()) {
            builder.data = serviceMessage.data();
        }
        serviceMessage.headers().forEach(builder::header);
        return builder;
    }

    private GatewayMessage(Builder builder) {
        this.data = builder.data;
        this.headers = Collections.unmodifiableMap(new HashMap(builder.headers));
    }

    public static ServiceMessage toServiceMessage(GatewayMessage gatewayMessage) {
        ServiceMessage.Builder builder = ServiceMessage.builder().qualifier(gatewayMessage.qualifier()).data(gatewayMessage.data);
        gatewayMessage.headers.forEach((arg_0, arg_1) -> ((ServiceMessage.Builder)builder).header(arg_0, arg_1));
        return builder.build();
    }

    public String qualifier() {
        return this.headers.get(QUALIFIER_FIELD);
    }

    public Long streamId() {
        String value = this.headers.get(STREAM_ID_FIELD);
        return value != null ? Long.valueOf(Long.parseLong(value)) : null;
    }

    public Integer signal() {
        String value = this.headers.get(SIGNAL_FIELD);
        return value != null ? Integer.valueOf(value) : null;
    }

    public <T> T data() {
        return (T)this.data;
    }

    public Integer inactivity() {
        String value = this.headers.get(INACTIVITY_FIELD);
        return value != null ? Integer.valueOf(value) : null;
    }

    public boolean hasSignal(Signal signal) {
        String value = this.headers.get(SIGNAL_FIELD);
        return value != null && Integer.parseInt(value) == signal.code();
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public boolean hasHeader(String name) {
        return this.headers.containsKey(name);
    }

    public String toString() {
        return "GatewayMessage {headers: " + this.headers + ", data: " + this.dataToString() + '}';
    }

    private Object dataToString() {
        if (this.data instanceof ByteBuf) {
            return "bb-" + ((ByteBuf)this.data).readableBytes();
        }
        if (this.data instanceof String) {
            return "str-" + ((String)this.data).length();
        }
        return this.data;
    }

    public static class Builder {
        private Map<String, String> headers = new HashMap<String, String>();
        private Object data;

        Builder() {
        }

        public Builder qualifier(String qualifier) {
            return this.header(GatewayMessage.QUALIFIER_FIELD, qualifier);
        }

        public Builder streamId(Long streamId) {
            return this.header(GatewayMessage.STREAM_ID_FIELD, streamId);
        }

        public Builder signal(Integer signal) {
            return this.header(GatewayMessage.SIGNAL_FIELD, signal);
        }

        public Builder signal(Signal signal) {
            return this.signal(signal.code());
        }

        public Builder inactivity(Integer inactivity) {
            return this.header(GatewayMessage.INACTIVITY_FIELD, inactivity);
        }

        public Builder data(Object data) {
            this.data = data;
            return this;
        }

        public Builder header(String key, String value) {
            if (value != null) {
                this.headers.put(key, value);
            }
            return this;
        }

        public Builder header(String key, Object value) {
            if (value != null) {
                this.headers.put(key, value.toString());
            }
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers.putAll(headers);
            return this;
        }

        public GatewayMessage build() {
            return new GatewayMessage(this);
        }
    }
}

