/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.gateway.websocket;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.ipc.netty.NettyPipeline;
import reactor.ipc.netty.http.server.HttpServerRequest;
import reactor.ipc.netty.http.websocket.WebsocketInbound;
import reactor.ipc.netty.http.websocket.WebsocketOutbound;

public final class WebsocketSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsocketSession.class);
    public static final String DEFAULT_CONTENT_TYPE = "application/json";
    public static final int STATUS_CODE_NORMAL_CLOSE = 1000;
    private final Map<Long, Disposable> subscriptions = new ConcurrentHashMap<Long, Disposable>();
    private final WebsocketInbound inbound;
    private final WebsocketOutbound outbound;
    private final String id = Integer.toHexString(System.identityHashCode(this));
    private final String contentType;

    public WebsocketSession(HttpServerRequest httpRequest, WebsocketInbound inbound, WebsocketOutbound outbound) {
        HttpHeaders httpHeaders = httpRequest.requestHeaders();
        this.contentType = Optional.ofNullable(httpHeaders.get((CharSequence)HttpHeaderNames.CONTENT_TYPE)).orElse(DEFAULT_CONTENT_TYPE);
        this.inbound = inbound;
        this.outbound = (WebsocketOutbound)outbound.options(NettyPipeline.SendOptions::flushOnEach);
        inbound.context().onClose(this::clearSubscriptions);
    }

    public String id() {
        return this.id;
    }

    public String contentType() {
        return this.contentType;
    }

    public Flux<ByteBuf> receive() {
        return this.inbound.aggregateFrames().receive().map(ByteBuf::retain).log(">> RECEIVE", Level.FINE, new SignalType[0]);
    }

    public Mono<Void> send(Publisher<ByteBuf> publisher) {
        return this.outbound.sendObject((Publisher)Flux.from(publisher).map(TextWebSocketFrame::new).log("<< SEND", Level.FINE, new SignalType[0])).then();
    }

    public Mono<Void> close() {
        return this.outbound.sendObject((Object)new CloseWebSocketFrame(1000, "close")).then().log("<< CLOSE", Level.FINE, new SignalType[0]);
    }

    public void onClose(Runnable runnable) {
        this.inbound.context().onClose(runnable);
    }

    public boolean dispose(Long streamId) {
        boolean result = false;
        if (streamId != null) {
            Disposable disposable = this.subscriptions.remove(streamId);
            boolean bl = result = disposable != null;
            if (result) {
                LOGGER.debug("Dispose subscription by sid: {} on session: {}", (Object)streamId, (Object)this);
                disposable.dispose();
            }
        }
        return result;
    }

    public boolean containsSid(Long streamId) {
        return streamId != null && this.subscriptions.containsKey(streamId);
    }

    public boolean register(Long streamId, Disposable disposable) {
        boolean result = false;
        if (!disposable.isDisposed()) {
            boolean bl = result = this.subscriptions.putIfAbsent(streamId, disposable) == null;
        }
        if (result) {
            LOGGER.debug("Registered subscription with sid: {} on session: {}", (Object)streamId, (Object)this);
        }
        return result;
    }

    private void clearSubscriptions() {
        if (!this.subscriptions.isEmpty()) {
            LOGGER.info("Clear all {} subscriptions on session: {}", (Object)this.subscriptions.size(), (Object)this);
        }
        this.subscriptions.forEach((sid, disposable) -> disposable.dispose());
        this.subscriptions.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WebsocketSession{");
        sb.append("id='").append(this.id).append('\'');
        sb.append(", contentType='").append(this.contentType).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

