/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.gateway.websocket;

import io.netty.util.concurrent.DefaultThreadFactory;
import io.scalecube.gateway.GatewayMetrics;
import io.scalecube.gateway.GatewayTemplate;
import io.scalecube.gateway.websocket.GatewayWebsocketAcceptor;
import io.scalecube.services.ServiceCall;
import io.scalecube.services.gateway.GatewayConfig;
import io.scalecube.services.metrics.Metrics;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.tcp.BlockingNettyContext;

public class WebsocketGateway
extends GatewayTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsocketGateway.class);
    private static final DefaultThreadFactory BOSS_THREAD_FACTORY = new DefaultThreadFactory("ws-boss", true);
    private static final Duration START_TIMEOUT = Duration.ofSeconds(30L);
    private BlockingNettyContext server;

    public Mono<InetSocketAddress> start(GatewayConfig config, Executor workerThreadPool, boolean preferNative, ServiceCall.Call call, Metrics metrics) {
        return Mono.defer(() -> {
            LOGGER.info("Starting gateway with {}", (Object)config);
            GatewayMetrics gatewayMetrics = new GatewayMetrics(config.name(), metrics);
            GatewayWebsocketAcceptor websocketAcceptor = new GatewayWebsocketAcceptor(call.create(), gatewayMetrics);
            this.server = this.prepareHttpServer(this.prepareLoopResources(preferNative, (ThreadFactory)BOSS_THREAD_FACTORY, config, workerThreadPool), gatewayMetrics, config.port()).start((BiFunction)websocketAcceptor, START_TIMEOUT);
            InetSocketAddress address = this.server.getContext().address();
            LOGGER.info("Gateway has been started successfully on {}", (Object)address);
            return Mono.just((Object)address);
        });
    }

    public Mono<Void> stop() {
        return Mono.defer(() -> {
            ArrayList<Mono> stopList = new ArrayList<Mono>();
            stopList.add(this.shutdownBossGroup());
            if (this.server != null) {
                this.server.getContext().dispose();
                stopList.add(this.server.getContext().onClose());
            }
            return Mono.when(stopList);
        });
    }
}

