/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.gateway.examples;

import io.scalecube.config.ConfigRegistry;
import io.scalecube.gateway.config.GatewayConfigRegistry;
import io.scalecube.gateway.examples.ExamplesConfig;
import io.scalecube.gateway.examples.GreetingServiceImpl;
import io.scalecube.services.Microservices;
import io.scalecube.transport.Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExamplesRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExamplesRunner.class);
    private static final String DECORATOR = "***********************************************************************";

    public static void main(String[] args) throws InterruptedException {
        ConfigRegistry configRegistry = GatewayConfigRegistry.configRegistry();
        ExamplesConfig config = (ExamplesConfig)configRegistry.objectValue("io.scalecube.gateway.examples", ExamplesConfig.class, null);
        LOGGER.info(DECORATOR);
        LOGGER.info("Starting Examples services on " + config);
        LOGGER.info(DECORATOR);
        int servicePort = config.getServicePort();
        Address seedAddress = Address.from((String)config.getSeedAddress());
        Microservices.builder().seeds(new Address[]{seedAddress}).servicePort(servicePort).services(new Object[]{new GreetingServiceImpl()}).startAwait();
        Thread.currentThread().join();
    }
}

