/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.examples.services;

import io.scalecube.examples.services.GreetingService;
import io.scalecube.examples.services.GreetingServiceImpl;
import io.scalecube.services.Microservices;
import io.scalecube.transport.Address;
import java.util.concurrent.CompletableFuture;

public class MicroservicesExample {
    public static void main(String[] args) throws Exception {
        Address providerAddress = MicroservicesExample.onProvider();
        MicroservicesExample.onConsumer(providerAddress);
    }

    private static Address onProvider() {
        Microservices provider = Microservices.builder().services(new Object[]{new GreetingServiceImpl()}).build();
        return provider.cluster().address();
    }

    private static void onConsumer(Address providerAddress) throws Exception {
        Microservices consumer = Microservices.builder().seeds(new Address[]{providerAddress}).build();
        GreetingService greetingService = (GreetingService)consumer.proxy().api(GreetingService.class).create();
        CompletableFuture<String> future = greetingService.greeting("Joe");
        future.whenComplete((result, exception) -> System.out.println("Consumer: 'greeting' <- " + (exception == null ? result : exception)));
        CompletableFuture<String> futureError = greetingService.greetingException("Joe");
        futureError.whenComplete((result, exception) -> System.out.println("Consumer: 'greetingException' <- " + (exception == null ? result : exception)));
    }
}

