/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.examples.gateway;

import io.scalecube.gateway.http.GatewayHttpServer;
import io.scalecube.gateway.socketio.GatewaySocketIoServer;
import io.scalecube.ipc.ClientStream;
import io.scalecube.ipc.ListeningServerStream;
import io.scalecube.ipc.ServerStream;
import io.scalecube.ipc.ServiceMessage;
import io.scalecube.transport.Address;

public final class GatewayRunner {
    public static void main(String[] args) throws Exception {
        ClientStream clientStream = ClientStream.newClientStream();
        ServerStream serverStream = ServerStream.newServerStream();
        serverStream.listenReadSuccess().subscribe(event -> {
            System.out.println("Sending ...");
            clientStream.send(Address.create((String)"127.0.0.1", (int)5801), (ServiceMessage)event.getMessage().get());
        });
        clientStream.listenReadSuccess().subscribe(event -> {
            System.out.println("Got reply: " + event + " sending it back to gateway client");
            serverStream.send((ServiceMessage)event.getMessage().get());
        });
        GatewaySocketIoServer.onPort((int)4040, (ServerStream)serverStream).start();
        GatewayHttpServer.onPort((int)8080, (ServerStream)serverStream).start();
        ListeningServerStream serverStream1 = ListeningServerStream.newServerStream().withListenAddress("127.0.0.1").withPort(5801).bind();
        serverStream1.listenReadSuccess().subscribe(event -> serverStream1.send((ServiceMessage)event.getMessage().get()));
        Thread.currentThread().join();
    }
}

