/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.examples;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import io.scalecube.cluster.Cluster;
import io.scalecube.cluster.ICluster;
import io.scalecube.transport.Address;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class MembershipEventsExample {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");

    public static void main(String[] args) throws Exception {
        ICluster alice = Cluster.joinAwait((Map)ImmutableMap.of((Object)"name", (Object)"Alice"), (Address[])new Address[0]);
        System.out.println(MembershipEventsExample.now() + " Alice join members: " + alice.members());
        alice.listenMembership().subscribe(event -> System.out.println(MembershipEventsExample.now() + " Alice received: " + event));
        ICluster bob = Cluster.joinAwait((Map)ImmutableMap.of((Object)"name", (Object)"Bob"), (Address[])new Address[]{alice.address()});
        System.out.println(MembershipEventsExample.now() + " Bob join members: " + bob.members());
        bob.listenMembership().subscribe(event -> System.out.println(MembershipEventsExample.now() + " Bob received: " + event));
        ICluster carol = Cluster.joinAwait((Map)ImmutableMap.of((Object)"name", (Object)"Carol"), (Address[])new Address[]{alice.address(), bob.address()});
        System.out.println(MembershipEventsExample.now() + " Carol join members: " + carol.members());
        carol.listenMembership().subscribe(event -> System.out.println(MembershipEventsExample.now() + " Carol received: " + event));
        ListenableFuture shutdownFuture = bob.shutdown();
        shutdownFuture.get();
        long maxRemoveTimeout = 6000L;
        Thread.sleep(maxRemoveTimeout);
    }

    private static String now() {
        return sdf.format(new Date());
    }
}

