/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.gateway.examples;

import io.scalecube.config.ConfigRegistry;
import io.scalecube.gateway.benchmarks.BenchmarksServiceImpl;
import io.scalecube.gateway.config.GatewayConfigRegistry;
import io.scalecube.gateway.examples.GreetingServiceImpl;
import io.scalecube.services.Microservices;
import io.scalecube.transport.Address;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExamplesRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExamplesRunner.class);
    private static final String DECORATOR = "***********************************************************************";

    public static void main(String[] args) throws Exception {
        ConfigRegistry configRegistry = GatewayConfigRegistry.configRegistry();
        Config config = (Config)configRegistry.objectProperty("io.scalecube.gateway.examples", Config.class).value().orElseThrow(() -> new IllegalStateException("Couldn't load config"));
        LOGGER.info(DECORATOR);
        LOGGER.info("Starting Examples services on {}", (Object)config);
        LOGGER.info(DECORATOR);
        Microservices.builder().discovery(options -> options.seeds(config.seedAddresses()).port(Integer.valueOf(config.discoveryPort())).memberHost(config.memberHost()).memberPort(config.memberPort())).servicePort(config.servicePort()).numOfThreads(config.numOfThreads()).servicePort(config.servicePort()).services(new Object[]{new BenchmarksServiceImpl(), new GreetingServiceImpl()}).startAwait();
        Thread.currentThread().join();
    }

    public static class Config {
        private int servicePort;
        private int discoveryPort;
        private int numOfThreads;
        private List<String> seeds;
        private String memberHost;
        private Integer memberPort;

        public int servicePort() {
            return this.servicePort;
        }

        public int discoveryPort() {
            return this.discoveryPort;
        }

        public int numOfThreads() {
            return this.numOfThreads;
        }

        public List<String> seeds() {
            return this.seeds;
        }

        public Address[] seedAddresses() {
            return Optional.ofNullable(this.seeds()).map(seeds -> (Address[])seeds.stream().map(Address::from).toArray(Address[]::new)).orElse(new Address[0]);
        }

        public String memberHost() {
            return this.memberHost;
        }

        public Integer memberPort() {
            return this.memberPort;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Config{");
            sb.append("servicePort=").append(this.servicePort);
            sb.append(", discoveryPort=").append(this.discoveryPort);
            sb.append(", numOfThreads=").append(this.numOfThreads);
            sb.append(", seeds=").append(this.seeds);
            sb.append(", memberHost=").append(this.memberHost);
            sb.append(", memberPort=").append(this.memberPort);
            sb.append('}');
            return sb.toString();
        }
    }
}

