/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.config.examples;

import io.scalecube.config.ConfigRegistry;
import io.scalecube.config.ConfigRegistrySettings;
import io.scalecube.config.StringConfigProperty;
import io.scalecube.config.source.ClassPathConfigSource;
import io.scalecube.config.source.ConfigSource;
import io.scalecube.config.source.SystemPropertiesConfigSource;
import java.nio.file.Path;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PredicateOrderingConfigExample {
    public static void main(String[] args) {
        Predicate<Path> propsPredicate = path -> path.toString().endsWith(".props");
        Predicate<Path> rootPredicate = propsPredicate.and(path -> path.toString().contains("config.props"));
        Predicate<Path> firstPredicate = propsPredicate.and(path -> path.toString().contains("order1"));
        Predicate<Path> secondPredicate = propsPredicate.and(path -> path.toString().contains("order2"));
        Predicate<Path> customSysPredicate = propsPredicate.and(path -> path.toString().contains("customSys"));
        ConfigRegistry configRegistry = ConfigRegistry.create((ConfigRegistrySettings)ConfigRegistrySettings.builder().addLastSource("sysProps", (ConfigSource)new SystemPropertiesConfigSource()).addLastSource("customSysProps", (ConfigSource)new SystemPropertiesConfigSource((ConfigSource)new ClassPathConfigSource(customSysPredicate))).addLastSource("classpath", (ConfigSource)new ClassPathConfigSource(Stream.of(firstPredicate, secondPredicate, rootPredicate).collect(Collectors.toList()))).build());
        StringConfigProperty orderedProp1 = configRegistry.stringProperty("orderedProp1");
        String foo = configRegistry.stringProperty("foo").valueOrThrow();
        String bar = configRegistry.stringProperty("bar").valueOrThrow();
        String sysFoo = configRegistry.stringProperty("sys.foo").valueOrThrow();
        System.out.println("### Matched by first predicate: orderedProp1=" + (String)orderedProp1.value().get());
        System.out.println("### Regardeless of predicates: foo=" + foo + ", bar=" + bar);
        System.out.println("### Custom system property: sysFoo=" + sysFoo + ", System.getProperty(sysFoo)=" + System.getProperty("sys.foo"));
    }
}

